/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ingest.common;

import io.skylite.common.processor.AbstractProcessor;
import io.skylite.core.ingest.ConfigurationUtils;
import io.skylite.core.ingest.IngestDocument;
import io.skylite.core.ingest.IngestProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class ConvertProcessor
extends AbstractProcessor
implements IngestProcessor {
    public static final String TYPE = "convert";
    private final String field;
    private final String targetField;
    private final Type convertType;
    private final boolean ignoreMissing;

    ConvertProcessor(String tag, String description, String field, String targetField, Type convertType, boolean ignoreMissing) {
        super(tag, description);
        this.field = field;
        this.targetField = targetField;
        this.convertType = convertType;
        this.ignoreMissing = ignoreMissing;
    }

    String getField() {
        return this.field;
    }

    String getTargetField() {
        return this.targetField;
    }

    Type getConvertType() {
        return this.convertType;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public IngestDocument execute(IngestDocument document) {
        ArrayList<Object> newValue;
        Object oldValue = document.getFieldValue(this.field, Object.class, this.ignoreMissing);
        if (oldValue == null && this.ignoreMissing) {
            return document;
        }
        if (oldValue == null) {
            throw new IllegalArgumentException("Field [" + this.field + "] is null, cannot be converted to type [" + String.valueOf((Object)this.convertType) + "]");
        }
        if (oldValue instanceof List) {
            List list = (List)oldValue;
            ArrayList<Object> newList = new ArrayList<Object>(list.size());
            for (Object value : list) {
                newList.add(this.convertType.convert(value));
            }
            newValue = newList;
        } else {
            newValue = this.convertType.convert(oldValue);
        }
        document.setFieldValue(this.targetField, (Object)newValue);
        return document;
    }

    public String getType() {
        return TYPE;
    }

    static enum Type {
        INTEGER{

            @Override
            public Object convert(Object value) {
                try {
                    String strValue = value.toString();
                    if (strValue.startsWith("0x") || strValue.startsWith("-0x")) {
                        return Integer.decode(strValue);
                    }
                    return Integer.parseInt(strValue);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("unable to convert [" + String.valueOf(value) + "] to integer", e);
                }
            }
        }
        ,
        LONG{

            @Override
            public Object convert(Object value) {
                try {
                    String strValue = value.toString();
                    if (strValue.startsWith("0x") || strValue.startsWith("-0x")) {
                        return Long.decode(strValue);
                    }
                    return Long.parseLong(strValue);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("unable to convert [" + String.valueOf(value) + "] to long", e);
                }
            }
        }
        ,
        DOUBLE{

            @Override
            public Object convert(Object value) {
                try {
                    return Double.parseDouble(value.toString());
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("unable to convert [" + String.valueOf(value) + "] to double", e);
                }
            }
        }
        ,
        FLOAT{

            @Override
            public Object convert(Object value) {
                try {
                    return Float.valueOf(Float.parseFloat(value.toString()));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("unable to convert [" + String.valueOf(value) + "] to float", e);
                }
            }
        }
        ,
        BOOLEAN{

            @Override
            public Object convert(Object value) {
                if (value.toString().equalsIgnoreCase("true")) {
                    return true;
                }
                if (value.toString().equalsIgnoreCase("false")) {
                    return false;
                }
                throw new IllegalArgumentException("[" + String.valueOf(value) + "] is not a boolean value, cannot convert to boolean");
            }
        }
        ,
        STRING{

            @Override
            public Object convert(Object value) {
                return value.toString();
            }
        }
        ,
        AUTO{

            @Override
            public Object convert(Object value) {
                if (!(value instanceof String)) {
                    return value;
                }
                try {
                    return BOOLEAN.convert(value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        return INTEGER.convert(value);
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        try {
                            return LONG.convert(value);
                        }
                        catch (IllegalArgumentException illegalArgumentException3) {
                            try {
                                return FLOAT.convert(value);
                            }
                            catch (IllegalArgumentException illegalArgumentException4) {
                                try {
                                    return DOUBLE.convert(value);
                                }
                                catch (IllegalArgumentException illegalArgumentException5) {
                                    return value;
                                }
                            }
                        }
                    }
                }
            }
        };


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public abstract Object convert(Object var1);

        public static Type fromString(String processorTag, String propertyName, String type) {
            try {
                return Type.valueOf(type.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw ConfigurationUtils.newConfigurationException((String)ConvertProcessor.TYPE, (String)processorTag, (String)propertyName, (String)("type [" + type + "] not supported, cannot convert field."));
            }
        }
    }

    public static final class Factory
    implements AbstractProcessor.Factory<ConvertProcessor> {
        public ConvertProcessor create(Map<String, AbstractProcessor.Factory<?>> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)ConvertProcessor.TYPE, (String)processorTag, config, (String)"field");
            String typeProperty = ConfigurationUtils.readStringProperty((String)ConvertProcessor.TYPE, (String)processorTag, config, (String)"type");
            String targetField = ConfigurationUtils.readStringProperty((String)ConvertProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)field);
            Type convertType = Type.fromString(processorTag, "type", typeProperty);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)ConvertProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            return new ConvertProcessor(processorTag, description, field, targetField, convertType, ignoreMissing);
        }
    }
}

