/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ingest.common;

import io.lucenia.ingest.common.DateFormat;
import io.skylite.common.ExceptionsHelper;
import io.skylite.common.processor.AbstractProcessor;
import io.skylite.core.common.time.DateFormatter;
import io.skylite.core.ingest.ConfigurationUtils;
import io.skylite.core.ingest.IngestDocument;
import io.skylite.core.ingest.IngestProcessor;
import io.skylite.core.script.ScriptService;
import io.skylite.core.script.TemplateScript;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

public final class DateIndexNameProcessor
extends AbstractProcessor
implements IngestProcessor {
    public static final String TYPE = "date_index_name";
    private final String field;
    private final TemplateScript.Factory indexNamePrefixTemplate;
    private final TemplateScript.Factory dateRoundingTemplate;
    private final TemplateScript.Factory indexNameFormatTemplate;
    private final ZoneId timezone;
    private final List<Function<String, ZonedDateTime>> dateFormats;

    DateIndexNameProcessor(String tag, String description, String field, List<Function<String, ZonedDateTime>> dateFormats, ZoneId timezone, TemplateScript.Factory indexNamePrefixTemplate, TemplateScript.Factory dateRoundingTemplate, TemplateScript.Factory indexNameFormatTemplate) {
        super(tag, description);
        this.field = field;
        this.timezone = timezone;
        this.dateFormats = dateFormats;
        this.indexNamePrefixTemplate = indexNamePrefixTemplate;
        this.dateRoundingTemplate = dateRoundingTemplate;
        this.indexNameFormatTemplate = indexNameFormatTemplate;
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        Object obj = ingestDocument.getFieldValue(this.field, Object.class);
        String date = null;
        if (obj != null) {
            date = obj.toString();
        }
        ZonedDateTime dateTime = null;
        Exception lastException = null;
        for (Function<String, ZonedDateTime> dateParser : this.dateFormats) {
            try {
                dateTime = dateParser.apply(date);
            }
            catch (Exception e) {
                lastException = (Exception)ExceptionsHelper.useOrSuppress(lastException, (Throwable)e);
            }
        }
        if (dateTime == null) {
            throw new IllegalArgumentException("unable to parse date [" + date + "]", lastException);
        }
        String indexNamePrefix = ingestDocument.renderTemplate(this.indexNamePrefixTemplate);
        String indexNameFormat = ingestDocument.renderTemplate(this.indexNameFormatTemplate);
        String dateRounding = ingestDocument.renderTemplate(this.dateRoundingTemplate);
        DateFormatter formatter = DateFormatter.forPattern((String)indexNameFormat);
        String zone = this.timezone.equals(ZoneOffset.UTC) ? "UTC" : this.timezone.getId();
        StringBuilder builder = new StringBuilder().append('<').append(indexNamePrefix).append('{').append(formatter.format((TemporalAccessor)dateTime)).append("||/").append(dateRounding).append('{').append(indexNameFormat).append('|').append(zone).append('}').append('}').append('>');
        String dynamicIndexName = builder.toString();
        ingestDocument.setFieldValue(IngestDocument.Metadata.INDEX.getFieldName(), (Object)dynamicIndexName);
        return ingestDocument;
    }

    public String getType() {
        return TYPE;
    }

    String getField() {
        return this.field;
    }

    TemplateScript.Factory getIndexNamePrefixTemplate() {
        return this.indexNamePrefixTemplate;
    }

    TemplateScript.Factory getDateRoundingTemplate() {
        return this.dateRoundingTemplate;
    }

    TemplateScript.Factory getIndexNameFormatTemplate() {
        return this.indexNameFormatTemplate;
    }

    ZoneId getTimezone() {
        return this.timezone;
    }

    List<Function<String, ZonedDateTime>> getDateFormats() {
        return this.dateFormats;
    }

    public static final class Factory
    implements AbstractProcessor.Factory<DateIndexNameProcessor> {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public DateIndexNameProcessor create(Map<String, AbstractProcessor.Factory<?>> registry, String tag, String description, Map<String, Object> config) throws Exception {
            List<String> dateFormatStrings;
            String localeString = ConfigurationUtils.readOptionalStringProperty((String)DateIndexNameProcessor.TYPE, (String)tag, config, (String)"locale");
            String timezoneString = ConfigurationUtils.readOptionalStringProperty((String)DateIndexNameProcessor.TYPE, (String)tag, config, (String)"timezone");
            ZoneId timezone = timezoneString == null ? ZoneOffset.UTC : ZoneId.of(timezoneString);
            Locale locale = Locale.ENGLISH;
            if (localeString != null) {
                try {
                    locale = new Locale.Builder().setLanguageTag(localeString).build();
                }
                catch (IllformedLocaleException e) {
                    throw new IllegalArgumentException("Invalid language tag specified: " + localeString);
                }
            }
            if ((dateFormatStrings = ConfigurationUtils.readOptionalList((String)DateIndexNameProcessor.TYPE, (String)tag, config, (String)"date_formats")) == null) {
                dateFormatStrings = Collections.singletonList("yyyy-MM-dd'T'HH:mm:ss.SSSXX");
            }
            ArrayList<Function<String, ZonedDateTime>> dateFormats = new ArrayList<Function<String, ZonedDateTime>>(dateFormatStrings.size());
            for (String format : dateFormatStrings) {
                DateFormat dateFormat = DateFormat.fromString(format);
                dateFormats.add(dateFormat.getFunction(format, timezone, locale));
            }
            String field = ConfigurationUtils.readStringProperty((String)DateIndexNameProcessor.TYPE, (String)tag, config, (String)"field");
            String indexNamePrefix = ConfigurationUtils.readStringProperty((String)DateIndexNameProcessor.TYPE, (String)tag, config, (String)"index_name_prefix", (String)"");
            TemplateScript.Factory indexNamePrefixTemplate = ConfigurationUtils.compileTemplate((String)DateIndexNameProcessor.TYPE, (String)tag, (String)"index_name_prefix", (String)indexNamePrefix, (ScriptService)this.scriptService);
            String dateRounding = ConfigurationUtils.readStringProperty((String)DateIndexNameProcessor.TYPE, (String)tag, config, (String)"date_rounding");
            TemplateScript.Factory dateRoundingTemplate = ConfigurationUtils.compileTemplate((String)DateIndexNameProcessor.TYPE, (String)tag, (String)"date_rounding", (String)dateRounding, (ScriptService)this.scriptService);
            String indexNameFormat = ConfigurationUtils.readStringProperty((String)DateIndexNameProcessor.TYPE, (String)tag, config, (String)"index_name_format", (String)"yyyy-MM-dd");
            TemplateScript.Factory indexNameFormatTemplate = ConfigurationUtils.compileTemplate((String)DateIndexNameProcessor.TYPE, (String)tag, (String)"index_name_format", (String)indexNameFormat, (ScriptService)this.scriptService);
            return new DateIndexNameProcessor(tag, description, field, dateFormats, timezone, indexNamePrefixTemplate, dateRoundingTemplate, indexNameFormatTemplate);
        }
    }
}

