/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ingest.common;

import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.grok.Grok;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class GrokProcessorGetAction
extends ActionType<Response> {
    static final GrokProcessorGetAction INSTANCE = new GrokProcessorGetAction();
    static final String NAME = "cluster:admin/ingest/processor/grok/get";

    private GrokProcessorGetAction() {
        super(NAME, Response::new);
    }

    public static class RestAction
    extends BaseRestHandler {
        public List<RestHandler.Route> routes() {
            return Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_ingest/processor/grok"));
        }

        public String getName() {
            return "ingest_processor_grok_get";
        }

        protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
            boolean sorted = request.paramAsBoolean("s", false);
            Request grokPatternsRequest = new Request(sorted);
            return channel -> client.executeLocally((ActionType)INSTANCE, (ActionRequest)grokPatternsRequest, (ActionListener)new RestToXContentListener(channel));
        }
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private final Map<String, String> grokPatterns;
        private final Map<String, String> sortedGrokPatterns;

        @Inject
        public TransportAction(TransportService transportService, ActionFilters actionFilters) {
            this(transportService, actionFilters, Grok.BUILTIN_PATTERNS);
        }

        TransportAction(TransportService transportService, ActionFilters actionFilters, Map<String, String> grokPatterns) {
            super(GrokProcessorGetAction.NAME, transportService, actionFilters, Request::new);
            this.grokPatterns = grokPatterns;
            this.sortedGrokPatterns = new TreeMap<String, String>(this.grokPatterns);
        }

        protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
            try {
                listener.onResponse((Object)new Response(request.sorted() ? this.sortedGrokPatterns : this.grokPatterns));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final Map<String, String> grokPatterns;

        Response(Map<String, String> grokPatterns) {
            this.grokPatterns = grokPatterns;
        }

        Response(StreamInput in) throws IOException {
            super(in);
            this.grokPatterns = in.readMap(StreamInput::readString, StreamInput::readString);
        }

        public Map<String, String> getGrokPatterns() {
            return this.grokPatterns;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("patterns");
            builder.map(this.grokPatterns);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.grokPatterns, StreamOutput::writeString, StreamOutput::writeString);
        }
    }

    public static class Request
    extends ActionRequest {
        private final boolean sorted;

        public Request(boolean sorted) {
            this.sorted = sorted;
        }

        Request(StreamInput in) throws IOException {
            super(in);
            this.sorted = in.readBoolean();
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.sorted);
        }

        public boolean sorted() {
            return this.sorted;
        }
    }
}

