/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ingest.common;

import io.lucenia.ingest.common.AbstractStringProcessor;
import io.skylite.core.ingest.ConfigurationUtils;
import java.util.Map;
import java.util.regex.Pattern;

public final class GsubProcessor
extends AbstractStringProcessor<String> {
    public static final String TYPE = "gsub";
    private final Pattern pattern;
    private final String replacement;

    GsubProcessor(String tag, String description, String field, Pattern pattern, String replacement, boolean ignoreMissing, String targetField) {
        super(tag, description, ignoreMissing, targetField, field);
        this.pattern = pattern;
        this.replacement = replacement;
    }

    Pattern getPattern() {
        return this.pattern;
    }

    String getReplacement() {
        return this.replacement;
    }

    @Override
    protected String process(String value) {
        return this.pattern.matcher(value).replaceAll(this.replacement);
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    extends AbstractStringProcessor.Factory {
        public Factory() {
            super(GsubProcessor.TYPE);
        }

        protected GsubProcessor newProcessor(String processorTag, String description, Map<String, Object> config, String field, boolean ignoreMissing, String targetField) {
            Pattern searchPattern;
            String pattern = ConfigurationUtils.readStringProperty((String)GsubProcessor.TYPE, (String)processorTag, config, (String)"pattern");
            String replacement = ConfigurationUtils.readStringProperty((String)GsubProcessor.TYPE, (String)processorTag, config, (String)"replacement");
            try {
                searchPattern = Pattern.compile(pattern);
            }
            catch (Exception e) {
                throw ConfigurationUtils.newConfigurationException((String)GsubProcessor.TYPE, (String)processorTag, (String)"pattern", (String)("Invalid regex pattern. " + e.getMessage()));
            }
            return new GsubProcessor(processorTag, description, field, searchPattern, replacement, ignoreMissing, targetField);
        }
    }
}

