/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ingest.common;

import io.lucenia.ingest.common.AppendProcessor;
import io.lucenia.ingest.common.BytesProcessor;
import io.lucenia.ingest.common.ConvertProcessor;
import io.lucenia.ingest.common.CsvProcessor;
import io.lucenia.ingest.common.DateIndexNameProcessor;
import io.lucenia.ingest.common.DateProcessor;
import io.lucenia.ingest.common.DissectProcessor;
import io.lucenia.ingest.common.DotExpanderProcessor;
import io.lucenia.ingest.common.FailProcessor;
import io.lucenia.ingest.common.ForEachProcessor;
import io.lucenia.ingest.common.GrokProcessor;
import io.lucenia.ingest.common.GrokProcessorGetAction;
import io.lucenia.ingest.common.GsubProcessor;
import io.lucenia.ingest.common.HtmlStripProcessor;
import io.lucenia.ingest.common.JoinProcessor;
import io.lucenia.ingest.common.JsonProcessor;
import io.lucenia.ingest.common.KeyValueProcessor;
import io.lucenia.ingest.common.LowercaseProcessor;
import io.lucenia.ingest.common.RemoveProcessor;
import io.lucenia.ingest.common.RenameProcessor;
import io.lucenia.ingest.common.ScriptProcessor;
import io.lucenia.ingest.common.SetProcessor;
import io.lucenia.ingest.common.SortProcessor;
import io.lucenia.ingest.common.SplitProcessor;
import io.lucenia.ingest.common.TrimProcessor;
import io.lucenia.ingest.common.URLDecodeProcessor;
import io.lucenia.ingest.common.UppercaseProcessor;
import io.lucenia.plugins.ActionPlugin;
import io.lucenia.plugins.Plugin;
import io.skylite.common.processor.AbstractProcessor;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionType;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.ingest.DropProcessor;
import io.skylite.core.ingest.IngestProcessor;
import io.skylite.core.ingest.PipelineProcessor;
import io.skylite.core.plugins.IngestPlugin;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.IndexScopedSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsFilter;
import io.skylite.grok.Grok;
import io.skylite.grok.MatcherWatchdog;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.opensearch.rest.RestController;

public class IngestCommonModulePlugin
extends Plugin
implements ActionPlugin,
IngestPlugin {
    static final Setting<TimeValue> WATCHDOG_INTERVAL = Setting.timeSetting((String)"ingest.grok.watchdog.interval", (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<TimeValue> WATCHDOG_MAX_EXECUTION_TIME = Setting.timeSetting((String)"ingest.grok.watchdog.max_execution_time", (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    public Map<String, AbstractProcessor.Factory<?>> getProcessors(IngestProcessor.Parameters parameters) {
        HashMap<String, Object> processors = new HashMap<String, Object>();
        processors.put("date", new DateProcessor.Factory(parameters.scriptService));
        processors.put("set", new SetProcessor.Factory(parameters.scriptService));
        processors.put("append", new AppendProcessor.Factory(parameters.scriptService));
        processors.put("rename", new RenameProcessor.Factory(parameters.scriptService));
        processors.put("remove", new RemoveProcessor.Factory(parameters.scriptService));
        processors.put("split", new SplitProcessor.Factory());
        processors.put("join", new JoinProcessor.Factory());
        processors.put("uppercase", new UppercaseProcessor.Factory());
        processors.put("lowercase", new LowercaseProcessor.Factory());
        processors.put("trim", new TrimProcessor.Factory());
        processors.put("convert", new ConvertProcessor.Factory());
        processors.put("gsub", new GsubProcessor.Factory());
        processors.put("fail", new FailProcessor.Factory(parameters.scriptService));
        processors.put("foreach", new ForEachProcessor.Factory(parameters.scriptService));
        processors.put("date_index_name", new DateIndexNameProcessor.Factory(parameters.scriptService));
        processors.put("sort", new SortProcessor.Factory());
        processors.put("grok", new GrokProcessor.Factory(Grok.BUILTIN_PATTERNS, IngestCommonModulePlugin.createGrokThreadWatchdog(parameters)));
        processors.put("script", new ScriptProcessor.Factory(parameters.scriptService));
        processors.put("dot_expander", new DotExpanderProcessor.Factory());
        processors.put("json", new JsonProcessor.Factory());
        processors.put("kv", new KeyValueProcessor.Factory());
        processors.put("urldecode", new URLDecodeProcessor.Factory());
        processors.put("bytes", new BytesProcessor.Factory());
        processors.put("pipeline", new PipelineProcessor.Factory(parameters.ingestService));
        processors.put("dissect", new DissectProcessor.Factory());
        processors.put("drop", new DropProcessor.Factory());
        processors.put("html_strip", new HtmlStripProcessor.Factory());
        processors.put("csv", new CsvProcessor.Factory());
        return Collections.unmodifiableMap(processors);
    }

    public List<ActionPlugin.ActionHandler> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)GrokProcessorGetAction.INSTANCE, GrokProcessorGetAction.TransportAction.class, new Class[0]));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Collections.singletonList(new GrokProcessorGetAction.RestAction());
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(WATCHDOG_INTERVAL, WATCHDOG_MAX_EXECUTION_TIME);
    }

    private static MatcherWatchdog createGrokThreadWatchdog(IngestProcessor.Parameters parameters) {
        long intervalMillis = ((TimeValue)WATCHDOG_INTERVAL.get(parameters.env.settings())).getMillis();
        long maxExecutionTimeMillis = ((TimeValue)WATCHDOG_MAX_EXECUTION_TIME.get(parameters.env.settings())).getMillis();
        return MatcherWatchdog.newInstance((long)intervalMillis, (long)maxExecutionTimeMillis, (LongSupplier)parameters.relativeTimeSupplier, parameters.scheduler::apply);
    }
}

