/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.oracle.labs.mlrg.olcut.util.Pair;
import com.oracle.labs.mlrg.olcut.util.SortUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.tribuo.Output;
import org.tribuo.OutputInfo;
import org.tribuo.protos.core.OutputProto;
import org.tribuo.regression.protos.DimensionTupleProto;
import org.tribuo.regression.protos.RegressorProto;
import org.tribuo.util.Util;

public class Regressor
implements Output<Regressor>,
Iterable<DimensionTuple> {
    private static final long serialVersionUID = 1L;
    public static final double TOLERANCE = 1.0E-12;
    public static final String DEFAULT_NAME = "DIM";
    private final String[] names;
    private final double[] values;
    private final double[] variances;
    private boolean hashCache = false;
    private int hashCode;

    public Regressor(String[] names, double[] values, double[] variances) {
        if (names.length != values.length || names.length != variances.length) {
            throw new IllegalArgumentException("Arrays must be the same length, names.length=" + names.length + ", values.length=" + values.length + ",variances.length=" + variances.length);
        }
        int[] indices = SortUtil.argsort((Comparable[])names, (boolean)true);
        this.names = new String[names.length];
        this.values = new double[values.length];
        this.variances = new double[variances.length];
        for (int i = 0; i < indices.length; ++i) {
            this.names[i] = names[indices[i]];
            this.values[i] = values[indices[i]];
            this.variances[i] = variances[indices[i]];
        }
        HashSet<String> nameSet = new HashSet<String>(Arrays.asList(this.names));
        if (nameSet.size() != this.names.length) {
            throw new IllegalArgumentException("Names must all be unique, found " + (this.names.length - nameSet.size()) + " duplicates");
        }
    }

    public Regressor(String[] names, double[] values) {
        this(names, values, Util.generateUniformVector((int)values.length, (double)Double.NaN));
    }

    public Regressor(DimensionTuple[] dimensions) {
        int[] indices = SortUtil.argsort((Comparable[])Regressor.extractNames(dimensions), (boolean)true);
        this.names = new String[dimensions.length];
        this.values = new double[this.names.length];
        this.variances = new double[this.names.length];
        for (int i = 0; i < dimensions.length; ++i) {
            DimensionTuple cur = dimensions[indices[i]];
            this.names[i] = cur.getName();
            this.values[i] = cur.getValue();
            this.variances[i] = cur.getVariance();
        }
        HashSet<String> nameSet = new HashSet<String>(Arrays.asList(this.names));
        if (nameSet.size() != this.names.length) {
            throw new IllegalArgumentException("Names must be unique, found " + (this.names.length - nameSet.size()) + " duplicates");
        }
    }

    public Regressor(String name, double value) {
        this(name, value, Double.NaN);
    }

    public Regressor(String name, double value, double variance) {
        this.names = new String[]{name};
        this.values = new double[]{value};
        this.variances = new double[]{variance};
    }

    public static Regressor deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        RegressorProto proto = (RegressorProto)message.unpack(RegressorProto.class);
        if (proto.getNameCount() != proto.getValueCount() || proto.getNameCount() != proto.getVarianceCount()) {
            throw new IllegalArgumentException("Invalid protobuf, expected the same number of names, values and variances, found " + proto.getNameCount() + " names, " + proto.getValueCount() + " values and " + proto.getVarianceCount() + " variances");
        }
        String[] names = new String[proto.getNameCount()];
        double[] values = new double[proto.getNameCount()];
        double[] variances = new double[proto.getNameCount()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = proto.getName(i);
            values[i] = proto.getValue(i);
            variances[i] = proto.getVariance(i);
        }
        Regressor r = new Regressor(names, values, variances);
        return r;
    }

    public OutputProto serialize() {
        OutputProto.Builder outputBuilder = OutputProto.newBuilder();
        outputBuilder.setClassName(Regressor.class.getName());
        outputBuilder.setVersion(0);
        RegressorProto.Builder data = RegressorProto.newBuilder();
        for (int i = 0; i < this.names.length; ++i) {
            data.addName(this.names[i]);
            data.addValue(this.values[i]);
            data.addVariance(this.variances[i]);
        }
        outputBuilder.setSerializedData(Any.pack((Message)data.build()));
        return outputBuilder.build();
    }

    public int size() {
        return this.names.length;
    }

    public String[] getNames() {
        return this.names;
    }

    public double[] getValues() {
        return this.values;
    }

    public double[] getVariances() {
        return this.variances;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.names.length; ++i) {
            builder.append('(');
            if (Double.isNaN(this.variances[i])) {
                builder.append(this.names[i]);
                builder.append(',');
                builder.append(this.values[i]);
            } else {
                builder.append(this.names[i]);
                builder.append(',');
                builder.append(this.values[i]);
                builder.append(",var=");
                builder.append(this.variances[i]);
            }
            builder.append("),");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public Optional<DimensionTuple> getDimension(String name) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equals(name)) continue;
            return Optional.of(new DimensionTuple(name, this.values[i], this.variances[i]));
        }
        return Optional.empty();
    }

    public DimensionTuple getDimension(int idx) {
        if (idx < 0 || idx >= this.values.length) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of bounds for range [0," + this.values.length + "]");
        }
        return new DimensionTuple(this.names[idx], this.values[idx], this.variances[idx]);
    }

    @Override
    public Iterator<DimensionTuple> iterator() {
        return new RegressorIterator();
    }

    public Regressor copy() {
        return new Regressor(this.names, Arrays.copyOf(this.values, this.values.length), Arrays.copyOf(this.variances, this.variances.length));
    }

    public String getSerializableForm(boolean includeConfidence) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.names.length; ++i) {
            builder.append(this.names[i]);
            builder.append('=');
            builder.append(this.values[i]);
            if (includeConfidence && !Double.isNaN(this.variances[i])) {
                builder.append('\u00b1');
                builder.append(this.variances[i]);
            }
            builder.append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public boolean fullEquals(Regressor other) {
        return this.fullEquals(other, 1.0E-12);
    }

    public boolean fullEquals(Regressor other, double tolerance) {
        if (!Arrays.equals(this.names, other.names)) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (Math.abs(this.values[i] - other.values[i]) > tolerance || Double.isNaN(this.values[i]) ^ Double.isNaN(other.values[i])) {
                return false;
            }
            double ourVar = this.variances[i];
            double otherVar = other.variances[i];
            if (!(Math.abs(ourVar - otherVar) > tolerance) && !(Double.isNaN(ourVar) ^ Double.isNaN(otherVar))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Regressor) {
            return Arrays.deepEquals(this.names, ((Regressor)o).names);
        }
        return false;
    }

    public synchronized int hashCode() {
        if (!this.hashCache) {
            this.hashCode = 11;
            for (int i = 0; i < this.names.length; ++i) {
                this.hashCode ^= this.names[i].hashCode();
            }
            this.hashCache = true;
        }
        return this.hashCode;
    }

    public String getDimensionNamesString() {
        return this.getDimensionNamesString(',');
    }

    public String getDimensionNamesString(char separator) {
        return String.join((CharSequence)("" + separator), this.names);
    }

    private static String[] extractNames(DimensionTuple[] values) {
        String[] extractedNames = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            extractedNames[i] = values[i].getName();
        }
        return extractedNames;
    }

    public static String[] extractNames(OutputInfo<Regressor> info) {
        Object[] extractedNames = new String[info.size()];
        int i = 0;
        for (Regressor r : info.getDomain()) {
            extractedNames[i] = r.getNames()[0];
            ++i;
        }
        Arrays.sort(extractedNames);
        return extractedNames;
    }

    public static Regressor parseString(String s) {
        return Regressor.parseString(s, ',');
    }

    public static Regressor parseString(String s, char splitChar) {
        if (splitChar == '=') {
            throw new IllegalArgumentException("Can't split on an equals symbol");
        }
        String[] tokens = s.split("" + splitChar);
        String[] names = new String[tokens.length];
        double[] values = new double[tokens.length];
        HashSet<String> nameSet = new HashSet<String>();
        for (int i = 0; i < tokens.length; ++i) {
            Pair<String, Double> element = Regressor.parseElement(i, tokens[i]);
            names[i] = (String)element.getA();
            values[i] = (Double)element.getB();
            nameSet.add((String)element.getA());
        }
        if (nameSet.size() != tokens.length) {
            throw new IllegalArgumentException("Duplicated dimension names");
        }
        return new Regressor(names, values);
    }

    public static Pair<String, Double> parseElement(int idx, String s) {
        String[] split = s.split("=");
        if (split.length == 2) {
            return new Pair((Object)split[0], (Object)Double.parseDouble(split[1]));
        }
        if (split.length == 1) {
            return new Pair((Object)("DIM-" + idx), (Object)Double.parseDouble(split[0]));
        }
        throw new IllegalArgumentException("Failed to parse element " + s);
    }

    public static Regressor createFromPairList(List<Pair<String, Double>> dimensions) {
        int numDimensions = dimensions.size();
        String[] names = new String[numDimensions];
        double[] values = new double[numDimensions];
        for (int i = 0; i < numDimensions; ++i) {
            Pair<String, Double> p = dimensions.get(i);
            names[i] = (String)p.getA();
            values[i] = (Double)p.getB();
        }
        return new Regressor(names, values);
    }

    public static final class DimensionTuple
    extends Regressor {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final double value;
        private final double variance;

        public DimensionTuple(String name, double value, double variance) {
            super(name, value, variance);
            this.name = name;
            this.value = value;
            this.variance = variance;
        }

        public DimensionTuple(String name, double value) {
            this(name, value, Double.NaN);
        }

        public static DimensionTuple deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
            if (version < 0 || version > 0) {
                throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
            }
            DimensionTupleProto proto = (DimensionTupleProto)message.unpack(DimensionTupleProto.class);
            return new DimensionTuple(proto.getName(), proto.getValue(), proto.getVariance());
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public String toString() {
            if (Double.isNaN(this.variance)) {
                return this.name + "=" + this.value;
            }
            return this.name + "=(" + this.value + ",var=" + this.variance + ")";
        }

        @Override
        public Optional<DimensionTuple> getDimension(String name) {
            if (this.name.equals(name)) {
                return Optional.of(this);
            }
            return Optional.empty();
        }

        @Override
        public Iterator<DimensionTuple> iterator() {
            return Collections.singletonList(this).iterator();
        }

        @Override
        public DimensionTuple copy() {
            return new DimensionTuple(this.name, this.value, this.variance);
        }

        public String getName() {
            return this.name;
        }

        public double getValue() {
            return this.value;
        }

        public double getVariance() {
            return this.variance;
        }

        @Override
        public String getSerializableForm(boolean includeConfidence) {
            String tmp = this.name + "=" + this.value;
            if (includeConfidence && !Double.isNaN(this.variance)) {
                return tmp + "\u00b1" + this.variance;
            }
            return tmp;
        }

        @Override
        public boolean fullEquals(Regressor other) {
            if (!this.equals(other)) {
                return false;
            }
            double otherValue = other.values[0];
            double otherVar = other.variances[0];
            if (Math.abs(this.value - otherValue) > 1.0E-12 || Double.isNaN(this.value) ^ Double.isNaN(otherValue)) {
                return false;
            }
            return !(Math.abs(this.variance - otherVar) > 1.0E-12) && Double.isNaN(this.variance) == Double.isNaN(otherVar);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof DimensionTuple) {
                return this.name.equals(((DimensionTuple)o).name);
            }
            if (o instanceof Regressor) {
                Regressor other = (Regressor)o;
                return other.size() == 1 && other.getNames()[0].equals(this.name);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 0xB ^ this.name.hashCode();
        }

        @Override
        public String getDimensionNamesString() {
            return this.name;
        }

        @Override
        public OutputProto serialize() {
            OutputProto.Builder outputBuilder = OutputProto.newBuilder();
            outputBuilder.setClassName(DimensionTuple.class.getName());
            outputBuilder.setVersion(0);
            DimensionTupleProto.Builder data = DimensionTupleProto.newBuilder();
            data.setName(this.name);
            data.setValue(this.value);
            data.setVariance(this.variance);
            outputBuilder.setSerializedData(Any.pack((Message)data.build()));
            return outputBuilder.build();
        }
    }

    private class RegressorIterator
    implements Iterator<DimensionTuple> {
        private int i = 0;

        private RegressorIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < Regressor.this.names.length;
        }

        @Override
        public DimensionTuple next() {
            DimensionTuple r = new DimensionTuple(Regressor.this.names[this.i], Regressor.this.values[this.i], Regressor.this.variances[this.i]);
            ++this.i;
            return r;
        }
    }
}

