/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.services.simpleemail.model.ExtensionField;
import com.amazonaws.services.simpleemail.model.MessageDsn;
import com.amazonaws.services.simpleemail.model.transform.ExtensionFieldStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class MessageDsnStaxUnmarshaller
implements Unmarshaller<MessageDsn, StaxUnmarshallerContext> {
    private static MessageDsnStaxUnmarshaller instance;

    public MessageDsn unmarshall(StaxUnmarshallerContext context) throws Exception {
        MessageDsn messageDsn = new MessageDsn();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return messageDsn;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ReportingMta", targetDepth)) {
                    messageDsn.setReportingMta(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ArrivalDate", targetDepth)) {
                    messageDsn.setArrivalDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("ExtensionFields", targetDepth)) {
                    messageDsn.withExtensionFields(new ArrayList<ExtensionField>());
                    continue;
                }
                if (!context.testExpression("ExtensionFields/member", targetDepth)) continue;
                messageDsn.withExtensionFields(ExtensionFieldStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return messageDsn;
    }

    public static MessageDsnStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MessageDsnStaxUnmarshaller();
        }
        return instance;
    }
}

