/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.blobstore;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.annotation.ExperimentalApi;
import io.skylite.common.blobstore.BlobMetadata;
import io.skylite.common.blobstore.BlobPath;
import io.skylite.common.blobstore.DeleteResult;
import io.skylite.common.blobstore.InputStreamWithMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public interface BlobContainer {
    public BlobPath path();

    public boolean blobExists(String var1) throws IOException;

    public InputStream readBlob(String var1) throws IOException;

    public InputStream readBlob(String var1, long var2, long var4) throws IOException;

    @ExperimentalApi
    default public InputStreamWithMetadata readBlobWithMetadata(String blobName) throws IOException {
        throw new UnsupportedOperationException("readBlobWithMetadata is not implemented yet");
    }

    @ExperimentalApi
    default public void writeBlobWithMetadata(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists, @Nullable Map<String, String> metadata) throws IOException {
        throw new UnsupportedOperationException("writeBlobWithMetadata is not implemented yet");
    }

    default public long readBlobPreferredLength() {
        throw new UnsupportedOperationException();
    }

    public void writeBlob(String var1, InputStream var2, long var3, boolean var5) throws IOException;

    public void writeBlobAtomic(String var1, InputStream var2, long var3, boolean var5) throws IOException;

    @ExperimentalApi
    default public void writeBlobAtomicWithMetadata(String blobName, InputStream inputStream, @Nullable Map<String, String> metadata, long blobSize, boolean failIfAlreadyExists) throws IOException {
        throw new UnsupportedOperationException("writeBlobAtomicWithMetadata is not implemented yet");
    }

    public DeleteResult delete() throws IOException;

    public void deleteBlobsIgnoringIfNotExists(List<String> var1) throws IOException;

    public Map<String, BlobMetadata> listBlobs() throws IOException;

    public Map<String, BlobContainer> children() throws IOException;

    public Map<String, BlobMetadata> listBlobsByPrefix(String var1) throws IOException;

    default public void listBlobsByPrefixInSortedOrder(String blobNamePrefix, int limit, BlobNameSortOrder blobNameSortOrder, ActionListener<List<BlobMetadata>> listener) {
        if (limit < 0) {
            throw new IllegalArgumentException("limit should not be a negative value");
        }
        try {
            listener.onResponse(this.listBlobsByPrefixInSortedOrder(blobNamePrefix, limit, blobNameSortOrder));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    default public List<BlobMetadata> listBlobsByPrefixInSortedOrder(String blobNamePrefix, int limit, BlobNameSortOrder blobNameSortOrder) throws IOException {
        if (limit < 0) {
            throw new IllegalArgumentException("limit should not be a negative value");
        }
        ArrayList<BlobMetadata> blobNames = new ArrayList<BlobMetadata>(this.listBlobsByPrefix(blobNamePrefix).values());
        blobNames.sort(blobNameSortOrder.comparator());
        return blobNames.subList(0, Math.min(blobNames.size(), limit));
    }

    public static enum BlobNameSortOrder {
        LEXICOGRAPHIC(Comparator.comparing(BlobMetadata::name));

        final Comparator<BlobMetadata> comparator;

        public Comparator<BlobMetadata> comparator() {
            return this.comparator;
        }

        private BlobNameSortOrder(Comparator<BlobMetadata> comparator) {
            this.comparator = comparator;
        }
    }
}

