/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.geometry;

import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.GeometryVisitor;
import io.skylite.common.geometry.ShapeType;
import io.skylite.common.geometry.utils.WellKnownText;
import java.util.Objects;

public class Ellipse
implements Geometry {
    public static final Ellipse EMPTY = new Ellipse();
    private final double y;
    private final double x;
    private final double z;
    private final double semiMajorAxisMeters;
    private final double semiMinorAxisMeters;
    private final double orientationDegrees;

    private Ellipse() {
        this.y = 0.0;
        this.x = 0.0;
        this.z = Double.NaN;
        this.semiMajorAxisMeters = -1.0;
        this.semiMinorAxisMeters = -1.0;
        this.orientationDegrees = Double.NaN;
    }

    public Ellipse(double x, double y, double semiMajorAxisMeters, double semiMinorAxisMeters, double orientationDegrees) {
        this(x, y, Double.NaN, semiMajorAxisMeters, semiMinorAxisMeters, orientationDegrees);
    }

    public Ellipse(double x, double y, double z, double semiMajorAxisMeters, double semiMinorAxisMeters, double orientationDegrees) {
        this.y = y;
        this.x = x;
        this.z = z;
        this.semiMajorAxisMeters = semiMajorAxisMeters;
        this.semiMinorAxisMeters = semiMinorAxisMeters;
        this.orientationDegrees = orientationDegrees;
    }

    @Override
    public ShapeType type() {
        return ShapeType.ELLIPSE;
    }

    public double getY() {
        return this.y;
    }

    public double getX() {
        return this.x;
    }

    public double getZ() {
        return this.z;
    }

    public double getLat() {
        return this.y;
    }

    public double getLon() {
        return this.x;
    }

    public double getAlt() {
        return this.x;
    }

    public double getSemiMajorAxisMeters() {
        return this.semiMajorAxisMeters;
    }

    public double getSemiMinorAxisMeters() {
        return this.semiMinorAxisMeters;
    }

    public double getOrientationDegrees() {
        return this.orientationDegrees;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ellipse ellipse = (Ellipse)o;
        return Double.compare(this.y, ellipse.y) == 0 && Double.compare(this.x, ellipse.x) == 0 && Double.compare(this.z, ellipse.z) == 0 && Double.compare(this.semiMajorAxisMeters, ellipse.semiMajorAxisMeters) == 0 && Double.compare(this.semiMinorAxisMeters, ellipse.semiMinorAxisMeters) == 0 && Double.compare(this.orientationDegrees, ellipse.orientationDegrees) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.y, this.x, this.z, this.semiMajorAxisMeters, this.semiMinorAxisMeters, this.orientationDegrees);
    }

    @Override
    public <T, E extends Exception> T visit(GeometryVisitor<T, E> visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    public boolean isEmpty() {
        return this.semiMinorAxisMeters < 0.0;
    }

    public String toString() {
        return WellKnownText.INSTANCE.toWKT(this);
    }

    @Override
    public boolean hasZ() {
        return !Double.isNaN(this.z);
    }
}

