/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.geometry.utils;

import io.skylite.common.geometry.Circle;
import io.skylite.common.geometry.Ellipse;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.GeometryCollection;
import io.skylite.common.geometry.GeometryVisitor;
import io.skylite.common.geometry.Line;
import io.skylite.common.geometry.LinearRing;
import io.skylite.common.geometry.MultiLine;
import io.skylite.common.geometry.MultiPoint;
import io.skylite.common.geometry.MultiPolygon;
import io.skylite.common.geometry.Point;
import io.skylite.common.geometry.Polygon;
import io.skylite.common.geometry.Rectangle;
import io.skylite.common.geometry.utils.GeometryValidator;

public class StandardValidator
implements GeometryValidator {
    private final boolean ignoreZValue;

    public StandardValidator(boolean ignoreZValue) {
        this.ignoreZValue = ignoreZValue;
    }

    protected void checkZ(double zValue) {
        if (!this.ignoreZValue && !Double.isNaN(zValue)) {
            throw new IllegalArgumentException("found Z value [" + zValue + "] but [ignore_z_value] parameter is [" + this.ignoreZValue + "]");
        }
    }

    @Override
    public void validate(Geometry geometry) {
        if (!this.ignoreZValue) {
            geometry.visit(new GeometryVisitor<Void, RuntimeException>(){

                @Override
                public Void visit(Circle circle) throws RuntimeException {
                    StandardValidator.this.checkZ(circle.getZ());
                    return null;
                }

                @Override
                public Void visit(Ellipse ellipse) throws RuntimeException {
                    StandardValidator.this.checkZ(ellipse.getZ());
                    return null;
                }

                @Override
                public Void visit(GeometryCollection<?> collection) throws RuntimeException {
                    for (Geometry g : collection) {
                        g.visit(this);
                    }
                    return null;
                }

                @Override
                public Void visit(Line line) throws RuntimeException {
                    for (int i = 0; i < line.length(); ++i) {
                        StandardValidator.this.checkZ(line.getZ(i));
                    }
                    return null;
                }

                @Override
                public Void visit(LinearRing ring) throws RuntimeException {
                    for (int i = 0; i < ring.length(); ++i) {
                        StandardValidator.this.checkZ(ring.getZ(i));
                    }
                    return null;
                }

                @Override
                public Void visit(MultiLine multiLine) throws RuntimeException {
                    return this.visit((GeometryCollection)multiLine);
                }

                @Override
                public Void visit(MultiPoint multiPoint) throws RuntimeException {
                    return this.visit((GeometryCollection)multiPoint);
                }

                @Override
                public Void visit(MultiPolygon multiPolygon) throws RuntimeException {
                    return this.visit((GeometryCollection)multiPolygon);
                }

                @Override
                public Void visit(Point point) throws RuntimeException {
                    StandardValidator.this.checkZ(point.getZ());
                    return null;
                }

                @Override
                public Void visit(Polygon polygon) throws RuntimeException {
                    polygon.getPolygon().visit(this);
                    for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
                        polygon.getHole(i).visit(this);
                    }
                    return null;
                }

                @Override
                public Void visit(Rectangle rectangle) throws RuntimeException {
                    StandardValidator.this.checkZ(rectangle.getMinZ());
                    StandardValidator.this.checkZ(rectangle.getMaxZ());
                    return null;
                }
            });
        }
    }
}

