/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.io;

import io.skylite.common.annotation.InternalApi;
import io.skylite.common.io.Channels;
import io.skylite.common.io.InputStreamContainer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.UnaryOperator;

@InternalApi
public class FilePartWriter {
    private static final int BUFFER_SIZE = 0xFD0000;

    private FilePartWriter() {
    }

    public static void write(Path fileLocation, InputStreamContainer stream, UnaryOperator<InputStream> rateLimiter) throws IOException {
        try (FileChannel outputFileChannel = FileChannel.open(fileLocation, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
             InputStream inputStream = (InputStream)rateLimiter.apply(stream.getInputStream());){
            int bytesRead;
            long streamOffset = stream.getOffset();
            byte[] buffer = new byte[0xFD0000];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                Channels.writeToChannel(buffer, 0, bytesRead, outputFileChannel, streamOffset);
                streamOffset += (long)bytesRead;
            }
        }
    }
}

