/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.profile;

import io.skylite.common.profile.Timer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractProfileBreakdown<T extends Enum<T>> {
    protected final Timer[] timings;
    protected final T[] timingTypes;
    public static final String TIMING_TYPE_COUNT_SUFFIX = "_count";
    public static final String TIMING_TYPE_START_TIME_SUFFIX = "_start_time";

    public AbstractProfileBreakdown(Class<T> clazz) {
        this.timingTypes = (Enum[])clazz.getEnumConstants();
        this.timings = new Timer[this.timingTypes.length];
        for (int i = 0; i < this.timings.length; ++i) {
            this.timings[i] = new Timer();
        }
    }

    public Timer getTimer(T timing) {
        return this.timings[((Enum)timing).ordinal()];
    }

    public void setTimer(T timing, Timer timer) {
        this.timings[((Enum)timing).ordinal()] = timer;
    }

    public Map<String, Long> toBreakdownMap() {
        HashMap<Object, Long> map = new HashMap<Object, Long>(this.timings.length * 3);
        for (T timingType : this.timingTypes) {
            map.put(((Enum)timingType).toString(), this.timings[((Enum)timingType).ordinal()].getApproximateTiming());
            map.put(String.valueOf(timingType) + TIMING_TYPE_COUNT_SUFFIX, this.timings[((Enum)timingType).ordinal()].getCount());
            map.put(String.valueOf(timingType) + TIMING_TYPE_START_TIME_SUFFIX, this.timings[((Enum)timingType).ordinal()].getEarliestTimerStartTime());
        }
        return Collections.unmodifiableMap(map);
    }

    public Map<String, Object> toDebugMap() {
        return Collections.emptyMap();
    }

    public long toNodeTime() {
        long total = 0L;
        for (T timingType : this.timingTypes) {
            total += this.timings[((Enum)timingType).ordinal()].getApproximateTiming();
        }
        return total;
    }
}

