/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.profile;

public class Timer {
    private boolean doTiming;
    private long timing;
    private long count;
    private long lastCount;
    private long start;
    private long earliestTimerStartTime;

    public Timer() {
        this(0L, 0L, 0L, 0L, 0L);
    }

    public Timer(long timing, long count, long lastCount, long start, long earliestTimerStartTime) {
        this.timing = timing;
        this.count = count;
        this.lastCount = lastCount;
        this.start = start;
        this.earliestTimerStartTime = earliestTimerStartTime;
    }

    long nanoTime() {
        return System.nanoTime();
    }

    public final void start() {
        assert (this.start == 0L) : "#start call misses a matching #stop call";
        boolean bl = this.doTiming = this.count - this.lastCount >= Math.min(this.lastCount >>> 8, 1024L);
        if (this.doTiming) {
            this.start = this.nanoTime();
            if (this.count == 0L) {
                this.earliestTimerStartTime = this.start;
            }
        }
        ++this.count;
    }

    public final void stop() {
        if (this.doTiming) {
            this.timing += (this.count - this.lastCount) * Math.max(this.nanoTime() - this.start, 1L);
            this.lastCount = this.count;
            this.start = 0L;
        }
    }

    public final long getCount() {
        if (this.start != 0L) {
            throw new IllegalStateException("#start call misses a matching #stop call");
        }
        return this.count;
    }

    public final long getEarliestTimerStartTime() {
        if (this.start != 0L) {
            throw new IllegalStateException("#start call misses a matching #stop call");
        }
        return this.earliestTimerStartTime;
    }

    public final long getApproximateTiming() {
        if (this.start != 0L) {
            throw new IllegalStateException("#start call misses a matching #stop call");
        }
        long timing = this.timing;
        if (this.count > this.lastCount) {
            assert (this.lastCount > 0L);
            timing += (this.count - this.lastCount) * timing / this.lastCount;
        }
        return timing;
    }
}

