/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.util;

import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;

public class Quantiles {
    public static double computePercentile(List<Double> data, double percentile) {
        if (data == null || data.isEmpty()) {
            throw new IllegalArgumentException("List must not be empty");
        }
        double[] dataset = data.stream().mapToDouble(Double::doubleValue).toArray();
        long numerator = (long)percentile * (long)(dataset.length - 1);
        int quotient = (int)Quantiles.longDivide(numerator, 100L, RoundingMode.DOWN);
        int remainder = (int)(numerator - (long)quotient * 100L);
        Quantiles.selectInPlace(quotient, dataset, 0, dataset.length - 1);
        if (remainder == 0) {
            return dataset[quotient];
        }
        Quantiles.selectInPlace(quotient + 1, dataset, quotient + 1, dataset.length - 1);
        return Quantiles.interpolate(dataset[quotient], dataset[quotient + 1], remainder, 100.0);
    }

    private static void selectInPlace(int required, double[] array, int from, int to) {
        if (required == from) {
            int min = from;
            for (int index = from + 1; index <= to; ++index) {
                if (!(array[min] > array[index])) continue;
                min = index;
            }
            if (min != from) {
                Quantiles.swap(array, min, from);
            }
            return;
        }
        while (to > from) {
            int partitionPoint = Quantiles.partition(array, from, to);
            if (partitionPoint >= required) {
                to = partitionPoint - 1;
            }
            if (partitionPoint > required) continue;
            from = partitionPoint + 1;
        }
    }

    private static void swap(double[] array, int i, int j) {
        double temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }

    private static int partition(double[] array, int from, int to) {
        Quantiles.movePivotToStartOfSlice(array, from, to);
        double pivot = array[from];
        int partitionPoint = to;
        for (int i = to; i > from; --i) {
            if (!(array[i] > pivot)) continue;
            Quantiles.swap(array, partitionPoint, i);
            --partitionPoint;
        }
        Quantiles.swap(array, from, partitionPoint);
        return partitionPoint;
    }

    private static void movePivotToStartOfSlice(double[] array, int from, int to) {
        boolean toLessThanFrom;
        int mid = from + to >>> 1;
        boolean toLessThanMid = array[to] < array[mid];
        boolean midLessThanFrom = array[mid] < array[from];
        boolean bl = toLessThanFrom = array[to] < array[from];
        if (toLessThanMid == midLessThanFrom) {
            Quantiles.swap(array, mid, from);
        } else if (toLessThanMid != toLessThanFrom) {
            Quantiles.swap(array, from, to);
        }
    }

    public static long longDivide(long p, long q, RoundingMode mode) {
        boolean increment;
        Objects.requireNonNull(mode);
        long div = p / q;
        long rem = p % q;
        if (rem == 0L) {
            return div;
        }
        int signum = Long.signum(p) * Long.signum(q);
        switch (mode) {
            case UNNECESSARY: {
                Quantiles.checkRoundingUnnecessary(rem == 0L);
                return div;
            }
            case DOWN: {
                return div;
            }
            case UP: {
                return div + (long)signum;
            }
            case CEILING: {
                increment = signum > 0;
                break;
            }
            case FLOOR: {
                increment = signum < 0;
                break;
            }
            case HALF_EVEN: 
            case HALF_DOWN: 
            case HALF_UP: {
                boolean closerToUp;
                long absRem = Math.abs(rem);
                boolean bl = closerToUp = 2L * absRem > Math.abs(q);
                if (2L * absRem == Math.abs(q)) {
                    increment = mode == RoundingMode.HALF_UP || mode == RoundingMode.HALF_EVEN && (div & 1L) != 0L;
                    break;
                }
                increment = closerToUp;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return increment ? div + (long)signum : div;
    }

    private static void checkRoundingUnnecessary(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }

    private static double interpolate(double lower, double upper, double remainder, double scale) {
        if (lower == Double.NEGATIVE_INFINITY) {
            if (upper == Double.POSITIVE_INFINITY) {
                return Double.NaN;
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (upper == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        return lower + (upper - lower) * remainder / scale;
    }
}

