/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public final class ValidationUtils {
    public static final Pattern CLUSTER_NAME_PATTERN;
    public static final Pattern CLUSTER_PATTERN_PATTERN;
    private static final Set<Character> VALID_ID_CHARS;
    private static final String INVALID_NAME_CHARS = "^\\*\\?<>|#";
    private static final Pattern VALID_EMAIL_PATTERN;

    private ValidationUtils() {
    }

    public static void validateUrl(String urlString) throws MalformedURLException {
        if (!ValidationUtils.isValidUrl(urlString)) {
            throw new MalformedURLException("Invalid URL or unsupported");
        }
    }

    public static void validateEmail(String email) {
        if (!ValidationUtils.isValidEmail(email)) {
            throw new IllegalArgumentException("Invalid email address");
        }
    }

    public static void validateId(String idString) {
        if (!ValidationUtils.isValidId(idString)) {
            StringBuilder invalidChars = new StringBuilder();
            for (char c : idString.toCharArray()) {
                if (VALID_ID_CHARS.contains(Character.valueOf(c))) continue;
                invalidChars.append(c);
            }
            throw new IllegalArgumentException("Invalid characters in id : " + String.valueOf(invalidChars));
        }
    }

    public static boolean isValidUrl(String urlString) {
        try {
            URL url = new URL(urlString);
            String protocol = url.getProtocol();
            return "https".equals(protocol) || "http".equals(protocol);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean isValidEmail(String email) {
        return VALID_EMAIL_PATTERN.matcher(email).matches();
    }

    public static boolean isValidId(String idString) {
        if (idString == null) {
            return false;
        }
        if (idString.trim().isEmpty()) {
            return false;
        }
        for (char c : idString.toCharArray()) {
            if (VALID_ID_CHARS.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public static void validateIamRoleArn(String roleArn) {
        Pattern roleArnRegex = Pattern.compile("^arn:aws(-[^:]+)?:iam::([0-9]{12}):([a-zA-Z_0-9+=,.@\\-_/]+)$");
        if (!roleArnRegex.matcher(roleArn).find()) {
            throw new IllegalArgumentException("Invalid AWS role ARN: " + roleArn + " ");
        }
    }

    public static boolean isValidName(String name) {
        String regex = "^(?![_\\-\\+])(?!.*\\.\\.)[^^\\*\\?<>|#]+$";
        return Pattern.compile(regex).matcher(name).matches();
    }

    public static String getInvalidNameChars() {
        return INVALID_NAME_CHARS;
    }

    static {
        char c;
        CLUSTER_NAME_PATTERN = Pattern.compile("^(?=.{1,255}$)[a-z0-9]([a-zA-Z0-9_-]*:?[a-zA-Z0-9_-]*)$");
        CLUSTER_PATTERN_PATTERN = Pattern.compile("^(?=.{1,255}$)[a-z0-9*]([a-zA-Z0-9_*-]*:?[a-zA-Z0-9_*-]*)$");
        VALID_ID_CHARS = new HashSet<Character>();
        for (c = 'a'; c <= 'z'; c = (char)(c + 1)) {
            VALID_ID_CHARS.add(Character.valueOf(c));
        }
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            VALID_ID_CHARS.add(Character.valueOf(c));
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            VALID_ID_CHARS.add(Character.valueOf(c));
        }
        VALID_ID_CHARS.add(Character.valueOf('+'));
        VALID_ID_CHARS.add(Character.valueOf('/'));
        VALID_ID_CHARS.add(Character.valueOf('_'));
        VALID_ID_CHARS.add(Character.valueOf('-'));
        VALID_EMAIL_PATTERN = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9]))\\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", 2);
    }
}

