/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.geographic.referencing;

import io.skylite.geographic.referencing.CRSProviderInterface;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

public class CRSProviderRegistry {
    private static Map<String, CRSProviderInterface> REGISTRY;
    private static CRSProviderInterface DEFAULT_CRS_PROVIDER;
    public static final CRSProviderInterface SIS;

    public static CRSProviderInterface fromName(String registeredCRSProviderName) {
        if (!REGISTRY.containsKey(registeredCRSProviderName.toLowerCase(Locale.ROOT))) {
            StringBuilder sb = new StringBuilder("unable to locate the requested spatial reference system provider [").append(registeredCRSProviderName).append("]. Options Are: [");
            String options = REGISTRY.keySet().stream().collect(Collectors.joining(", "));
            sb.append(options).append("]");
            throw new IllegalArgumentException(sb.toString());
        }
        return REGISTRY.get(registeredCRSProviderName);
    }

    public static Collection<String> registeredNames() {
        return Collections.unmodifiableCollection(REGISTRY.keySet());
    }

    private static void setDefaultCRSProvider(CRSProviderInterface crsProvider) {
        if (DEFAULT_CRS_PROVIDER != null) {
            throw new RuntimeException("unable to reset the default spatial coordinate reference system provider from current default [" + String.valueOf(DEFAULT_CRS_PROVIDER) + "] to [" + String.valueOf(crsProvider) + "]");
        }
        DEFAULT_CRS_PROVIDER = crsProvider;
    }

    public static CRSProviderInterface getDefaultCRSProvider() {
        return DEFAULT_CRS_PROVIDER;
    }

    static {
        HashMap<String, CRSProviderInterface> crsProviders = new HashMap<String, CRSProviderInterface>();
        for (CRSProviderInterface crsProvider : ServiceLoader.load(CRSProviderInterface.class, CRSProviderRegistry.class.getClassLoader())) {
            crsProviders.put(crsProvider.getName().toLowerCase(Locale.ROOT), crsProvider);
        }
        REGISTRY = Map.copyOf(crsProviders);
        SIS = REGISTRY.containsKey("sis") ? REGISTRY.get("sis") : null;
        CRSProviderRegistry.setDefaultCRSProvider(SIS);
    }
}

