/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.geographic.referencing;

import io.skylite.geographic.referencing.CRSProviderInterface;
import io.skylite.geographic.referencing.GeometryProcessorFieldType;
import java.security.AccessController;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.CoordinateTransform;
import org.locationtech.proj4j.CoordinateTransformFactory;
import org.locationtech.proj4j.ProjCoordinate;

public class Proj4JProvider
implements CRSProviderInterface<CoordinateReferenceSystem, CoordinateTransform> {
    private static final String NAME = "proj4j";
    private final CRSFactory crsFactory = AccessController.doPrivileged(() -> new CRSFactory());
    private final CoordinateTransformFactory transformFactory = AccessController.doPrivileged(() -> new CoordinateTransformFactory());
    static CoordinateReferenceSystem DEFAULT_TO_CRS;

    public Proj4JProvider() {
        DEFAULT_TO_CRS = this.crsFactory.createFromName("EPSG:4326");
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public CoordinateTransform getTransform(CoordinateReferenceSystem fromCRS, CoordinateReferenceSystem toCRS, Object ... extraArgs) throws Exception {
        return this.transformFactory.createTransform(fromCRS, toCRS);
    }

    @Override
    public CoordinateReferenceSystem getCRS(String crsSpec) throws Exception {
        if (crsSpec.indexOf("+") >= 0 || crsSpec.indexOf("=") >= 0) {
            return this.crsFactory.createFromParameters("Anon", crsSpec);
        }
        return this.crsFactory.createFromName(crsSpec);
    }

    @Override
    public CRSProviderInterface.CRSHandler<CoordinateReferenceSystem> createCRSHandler(String fromCRS, String toCRS, GeometryProcessorFieldType shapeFieldType) throws Exception {
        CoordinateReferenceSystem toReferenceSystem;
        CoordinateReferenceSystem coordinateReferenceSystem = toReferenceSystem = toCRS != null ? this.getCRS(toCRS) : DEFAULT_TO_CRS;
        if (fromCRS.equals(toReferenceSystem.getName())) {
            throw new IllegalArgumentException("destination coordinate reference system [" + toReferenceSystem.getName() + "] cannot be equal to source coordinate reference system [" + fromCRS + "]");
        }
        return new Proj4JHandler(this.getCRS(fromCRS), toReferenceSystem, this.getTransform(this.getCRS(fromCRS), toReferenceSystem, new Object[0]));
    }

    static class Proj4JHandler
    implements CRSProviderInterface.CRSHandler<CoordinateReferenceSystem> {
        private final CoordinateTransform transform;
        private final CoordinateReferenceSystem fromCRS;
        private final CoordinateReferenceSystem toCRS;
        private final ProjCoordinate reusableFrom;
        private final ProjCoordinate reusableTo;

        Proj4JHandler(CoordinateReferenceSystem fromCRS, CoordinateReferenceSystem toCRS, CoordinateTransform transform) {
            this.fromCRS = fromCRS;
            this.toCRS = toCRS;
            this.transform = transform;
            this.reusableFrom = new ProjCoordinate();
            this.reusableTo = new ProjCoordinate();
        }

        @Override
        public CoordinateReferenceSystem getFromCRS() {
            return this.fromCRS;
        }

        @Override
        public CoordinateReferenceSystem getToCRS() {
            return this.toCRS;
        }

        @Override
        public void reproject(double[] from, double[] to, double tolerance) throws Exception {
            this.reusableFrom.x = from[0];
            this.reusableFrom.y = from[1];
            this.transform.transform(this.reusableFrom, this.reusableTo);
            to[0] = this.reusableTo.x;
            to[1] = this.reusableTo.y;
        }
    }
}

