/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.geometry.utils;

import org.apache.lucene.util.SloppyMath;

public class GeospatialUtils {
    private GeospatialUtils() {
    }

    public static double crossTrackDistance(double centerLat, double centerLon, double aLat, double aLon, double bLat, double bLon) {
        double bearingAB = Math.toRadians(GeospatialUtils.initialBearing(aLat, aLon, bLat, bLon));
        double bearingAC = Math.toRadians(GeospatialUtils.initialBearing(aLat, aLon, centerLat, centerLon));
        double distanceAC = SloppyMath.haversinMeters((double)aLat, (double)aLon, (double)centerLat, (double)centerLon) / 6371008.7714;
        double crossTrack = Math.asin(Math.sin(distanceAC) * Math.sin(bearingAC - bearingAB));
        return Math.abs(crossTrack) * 6371008.7714;
    }

    public static double alongTrackDistance(double aLat, double aLon, double centerLat, double centerLon, double bLat, double bLon) {
        double distanceAC = SloppyMath.haversinMeters((double)aLat, (double)aLon, (double)centerLat, (double)centerLon) / 6371008.7714;
        double crossTrack = GeospatialUtils.crossTrackDistance(centerLat, centerLon, aLat, aLon, bLat, bLon) / 6371008.7714;
        double acosArgument = Math.cos(distanceAC) / Math.cos(crossTrack);
        acosArgument = Math.max(-1.0, Math.min(1.0, acosArgument));
        return Math.acos(acosArgument) * 6371008.7714;
    }

    public static double[] pointAlongGreatCircle(double aLat, double aLon, double alongTrackDistance, double initialBearing) {
        double angularDistance = alongTrackDistance / 6371008.7714;
        double lat = Math.asin(Math.sin(Math.toRadians(aLat)) * Math.cos(angularDistance) + Math.cos(Math.toRadians(aLat)) * Math.sin(angularDistance) * Math.cos(initialBearing));
        double lon = Math.toRadians(aLon) + Math.atan2(Math.sin(initialBearing) * Math.sin(angularDistance) * Math.cos(Math.toRadians(aLat)), Math.cos(angularDistance) - Math.sin(Math.toRadians(aLat)) * Math.sin(lat));
        return new double[]{Math.toDegrees(lat), Math.toDegrees(lon)};
    }

    public static double initialBearing(double aLat, double aLon, double bLat, double bLon) {
        double lat1 = Math.toRadians(aLat);
        double lon1 = Math.toRadians(aLon);
        double lat2 = Math.toRadians(bLat);
        double lon2 = Math.toRadians(bLon);
        double deltaLon = lon2 - lon1;
        if (Math.abs(lat1 - lat2) < 1.0E-6) {
            if (deltaLon > 0.0) {
                return 90.0;
            }
            return 270.0;
        }
        if (deltaLon < 0.0) {
            deltaLon += Math.PI * 2;
        }
        double y = Math.sin(deltaLon) * Math.cos(lat2);
        double x = Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(deltaLon);
        double initialBearingRad = Math.atan2(y, x);
        double initialBearingDeg = Math.toDegrees(initialBearingRad);
        double normalizedBearing = (initialBearingDeg + 360.0) % 360.0;
        return normalizedBearing;
    }

    public static double normalizeLongitude(double longitude) {
        if ((longitude = (longitude + 180.0) % 360.0) < 0.0) {
            longitude += 360.0;
        }
        return longitude - 180.0;
    }
}

