/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.grok;

import io.skylite.grok.GrokCaptureConfig;
import io.skylite.grok.GrokCaptureExtracter;
import io.skylite.grok.MatcherWatchdog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.function.Consumer;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Matcher;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;
import org.joni.exception.ValueException;

public final class Grok {
    public static final Map<String, String> BUILTIN_PATTERNS = Grok.loadBuiltinPatterns();
    private static final String NAME_GROUP = "name";
    private static final String SUBNAME_GROUP = "subname";
    private static final String PATTERN_GROUP = "pattern";
    private static final String DEFINITION_GROUP = "definition";
    private static final String GROK_PATTERN = "%\\{(?<name>(?<pattern>[A-z0-9]+)(?::(?<subname>[[:alnum:]@\\[\\]_:.-]+))?)(?:=(?<definition>(?:[^{}]+|\\.+)+))?\\}";
    private static final Regex GROK_PATTERN_REGEX = new Regex("%\\{(?<name>(?<pattern>[A-z0-9]+)(?::(?<subname>[[:alnum:]@\\[\\]_:.-]+))?)(?:=(?<definition>(?:[^{}]+|\\.+)+))?\\}".getBytes(StandardCharsets.UTF_8), 0, "%\\{(?<name>(?<pattern>[A-z0-9]+)(?::(?<subname>[[:alnum:]@\\[\\]_:.-]+))?)(?:=(?<definition>(?:[^{}]+|\\.+)+))?\\}".getBytes(StandardCharsets.UTF_8).length, 0, (Encoding)UTF8Encoding.INSTANCE, Syntax.DEFAULT);
    private static final int MAX_TO_REGEX_ITERATIONS = 100000;
    private final Map<String, String> patternBank;
    private final boolean namedCaptures;
    private final Regex compiledExpression;
    private final MatcherWatchdog matcherWatchdog;
    private final List<GrokCaptureConfig> captureConfig;

    public Grok(Map<String, String> patternBank, String grokPattern, Consumer<String> logCallBack) {
        this(patternBank, grokPattern, true, MatcherWatchdog.noop(), logCallBack);
    }

    public Grok(Map<String, String> patternBank, String grokPattern, MatcherWatchdog matcherWatchdog, Consumer<String> logCallBack) {
        this(patternBank, grokPattern, true, matcherWatchdog, logCallBack);
    }

    Grok(Map<String, String> patternBank, String grokPattern, boolean namedCaptures, Consumer<String> logCallBack) {
        this(patternBank, grokPattern, namedCaptures, MatcherWatchdog.noop(), logCallBack);
    }

    private Grok(Map<String, String> patternBank, String grokPattern, boolean namedCaptures, MatcherWatchdog matcherWatchdog, Consumer<String> logCallBack) {
        this.patternBank = patternBank;
        this.namedCaptures = namedCaptures;
        this.matcherWatchdog = matcherWatchdog;
        this.validatePatternBank();
        String expression = this.toRegex(grokPattern);
        byte[] expressionBytes = expression.getBytes(StandardCharsets.UTF_8);
        this.compiledExpression = new Regex(expressionBytes, 0, expressionBytes.length, 0, (Encoding)UTF8Encoding.INSTANCE, message -> logCallBack.accept(message));
        ArrayList<GrokCaptureConfig> captureConfig = new ArrayList<GrokCaptureConfig>();
        Iterator entry = this.compiledExpression.namedBackrefIterator();
        while (entry.hasNext()) {
            captureConfig.add(new GrokCaptureConfig((NameEntry)entry.next()));
        }
        this.captureConfig = Collections.unmodifiableList(captureConfig);
    }

    private void validatePatternBank() {
        for (String patternName : this.patternBank.keySet()) {
            this.validatePatternBank(patternName, new Stack<String>());
        }
    }

    private void validatePatternBank(String patternName, Stack<String> path) {
        boolean isSelfReference;
        String pattern = this.patternBank.get(patternName);
        boolean bl = isSelfReference = pattern.contains("%{" + patternName + "}") || pattern.contains("%{" + patternName + ":");
        if (isSelfReference) {
            Grok.throwExceptionForCircularReference(patternName, pattern);
        } else if (path.contains(patternName)) {
            String prevPatternName = path.pop();
            String prevPattern = this.patternBank.get(prevPatternName);
            Grok.throwExceptionForCircularReference(prevPatternName, prevPattern, patternName, path);
        }
        path.push(patternName);
        int i = pattern.indexOf("%{");
        while (i != -1) {
            int begin = i + 2;
            int syntaxEndIndex = pattern.indexOf(125, begin);
            if (syntaxEndIndex == -1) {
                throw new IllegalArgumentException("Malformed pattern [" + patternName + "][" + pattern + "]");
            }
            int semanticNameIndex = pattern.indexOf(58, begin);
            int end = syntaxEndIndex;
            if (semanticNameIndex != -1) {
                end = Math.min(syntaxEndIndex, semanticNameIndex);
            }
            String dependsOnPattern = pattern.substring(begin, end);
            this.validatePatternBank(dependsOnPattern, path);
            i = pattern.indexOf("%{", i + 1);
        }
        path.pop();
    }

    private static void throwExceptionForCircularReference(String patternName, String pattern) {
        Grok.throwExceptionForCircularReference(patternName, pattern, null, null);
    }

    private static void throwExceptionForCircularReference(String patternName, String pattern, String originPatterName, Stack<String> path) {
        StringBuilder message = new StringBuilder("circular reference in pattern [");
        message.append(patternName).append("][").append(pattern).append("]");
        if (originPatterName != null) {
            message.append(" back to pattern [").append(originPatterName).append("]");
        }
        if (path != null && path.size() > 1) {
            message.append(" via patterns [").append(String.join((CharSequence)"=>", path)).append("]");
        }
        throw new IllegalArgumentException(message.toString());
    }

    private String groupMatch(String name, Region region, String pattern) {
        try {
            int number = GROK_PATTERN_REGEX.nameToBackrefNumber(name.getBytes(StandardCharsets.UTF_8), 0, name.getBytes(StandardCharsets.UTF_8).length, region);
            int begin = region.getBeg(number);
            int end = region.getEnd(number);
            return new String(pattern.getBytes(StandardCharsets.UTF_8), begin, end - begin, StandardCharsets.UTF_8);
        }
        catch (StringIndexOutOfBoundsException e) {
            return null;
        }
        catch (ValueException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String toRegex(String grokPattern) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < 100000; ++i) {
            int result;
            byte[] grokPatternBytes = ((String)grokPattern).getBytes(StandardCharsets.UTF_8);
            Matcher matcher = GROK_PATTERN_REGEX.matcher(grokPatternBytes);
            try {
                this.matcherWatchdog.register(matcher);
                result = matcher.search(0, grokPatternBytes.length, 0);
            }
            finally {
                this.matcherWatchdog.unregister(matcher);
            }
            if (result < 0) {
                return res.append((String)grokPattern).toString();
            }
            Region region = matcher.getEagerRegion();
            String namedPatternRef = this.groupMatch(NAME_GROUP, region, (String)grokPattern);
            String subName = this.groupMatch(SUBNAME_GROUP, region, (String)grokPattern);
            String definition = this.groupMatch(DEFINITION_GROUP, region, (String)grokPattern);
            String patternName = this.groupMatch(PATTERN_GROUP, region, (String)grokPattern);
            String pattern = this.patternBank.get(patternName);
            if (pattern == null) {
                throw new IllegalArgumentException("Unable to find pattern [" + patternName + "] in Grok's pattern dictionary");
            }
            if (pattern.contains("%{" + patternName + "}") || pattern.contains("%{" + patternName + ":")) {
                throw new IllegalArgumentException("circular reference in pattern back [" + patternName + "]");
            }
            String grokPart = this.namedCaptures && subName != null ? String.format(Locale.US, "(?<%s>%s)", namedPatternRef, pattern) : (this.namedCaptures ? String.format(Locale.US, "(?:%s)", pattern) : String.format(Locale.US, "(?<%s>%s)", patternName + "_" + result, pattern));
            String start = new String(grokPatternBytes, 0, result, StandardCharsets.UTF_8);
            String rest = new String(grokPatternBytes, region.getEnd(0), grokPatternBytes.length - region.getEnd(0), StandardCharsets.UTF_8);
            grokPattern = grokPart + rest;
            res.append(start);
        }
        throw new IllegalArgumentException("Can not convert grok patterns to regular expression");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean match(String text) {
        int result;
        Matcher matcher = this.compiledExpression.matcher(text.getBytes(StandardCharsets.UTF_8));
        try {
            this.matcherWatchdog.register(matcher);
            result = matcher.search(0, text.length(), 0);
        }
        finally {
            this.matcherWatchdog.unregister(matcher);
        }
        return result != -1;
    }

    public Map<String, Object> captures(String text) {
        GrokCaptureExtracter.MapExtracter extracter;
        byte[] utf8Bytes = text.getBytes(StandardCharsets.UTF_8);
        if (this.match(utf8Bytes, 0, utf8Bytes.length, extracter = new GrokCaptureExtracter.MapExtracter(this.captureConfig))) {
            return extracter.result();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean match(byte[] utf8Bytes, int offset, int length, GrokCaptureExtracter extracter) {
        int result;
        Matcher matcher = this.compiledExpression.matcher(utf8Bytes, offset, offset + length);
        try {
            this.matcherWatchdog.register(matcher);
            result = matcher.search(offset, length, 0);
        }
        finally {
            this.matcherWatchdog.unregister(matcher);
        }
        if (result == -2) {
            throw new RuntimeException("grok pattern matching was interrupted after [" + this.matcherWatchdog.maxExecutionTimeInMillis() + "] ms");
        }
        if (result == -1) {
            return false;
        }
        extracter.extract(utf8Bytes, offset, matcher.getEagerRegion());
        return true;
    }

    public List<GrokCaptureConfig> captureConfig() {
        return this.captureConfig;
    }

    private static Map<String, String> loadBuiltinPatterns() {
        String[] patternNames = new String[]{"aws", "bacula", "bind", "bro", "exim", "firewalls", "grok-patterns", "haproxy", "java", "junos", "linux-syslog", "maven", "mcollective-patterns", "mongodb", "nagios", "postgresql", "rails", "redis", "ruby", "squid"};
        LinkedHashMap<String, String> builtinPatterns = new LinkedHashMap<String, String>();
        for (String pattern : patternNames) {
            try (InputStream is = Grok.class.getResourceAsStream("/patterns/" + pattern);){
                Grok.loadPatterns(builtinPatterns, is);
            }
            catch (IOException e) {
                throw new RuntimeException("failed to load built-in patterns", e);
            }
        }
        return Collections.unmodifiableMap(builtinPatterns);
    }

    private static void loadPatterns(Map<String, String> patternBank, InputStream inputStream) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        while ((line = br.readLine()) != null) {
            String[] parts;
            String trimmedLine = line.replaceAll("^\\s+", "");
            if (trimmedLine.startsWith("#") || trimmedLine.length() == 0 || (parts = trimmedLine.split("\\s+", 2)).length != 2) continue;
            patternBank.put(parts[0], parts[1]);
        }
    }
}

