/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.client.secure;

import io.lucenia.client.RestClient;
import io.lucenia.client.RestClientBuilder;
import io.lucenia.client.secure.ConfigConstants;
import io.lucenia.client.secure.TrustStore;
import io.skylite.SkyliteException;
import io.skylite.common.SecureString;
import io.skylite.core.common.Strings;
import io.skylite.core.settings.Settings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.client5.http.ssl.TrustSelfSignedStrategy;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.Timeout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SecureRestClientBuilder {
    private final boolean httpSSLEnabled;
    private final String user;
    private final String passwd;
    private final ArrayList<HttpHost> hosts = new ArrayList();
    private final Path configPath;
    private final Settings settings;
    private int defaultConnectTimeOutMSecs = 5000;
    private int defaultSoTimeoutMSecs = 10000;
    private int defaultConnRequestTimeoutMSecs = 180000;
    private int defaultMaxConnPerRoute = 10;
    private int defaultMaxConnTotal = 30;
    private static final Logger log = LogManager.getLogger(SecureRestClientBuilder.class);

    public SecureRestClientBuilder(String host, int port, boolean httpSSLEnabled, String user, String passWord) {
        if (Strings.isNullOrEmpty((String)user) || Strings.isNullOrEmpty((String)passWord)) {
            throw new IllegalArgumentException("Invalid user or password");
        }
        this.httpSSLEnabled = httpSSLEnabled;
        this.user = user;
        this.passwd = passWord;
        this.settings = Settings.EMPTY;
        this.configPath = null;
        this.hosts.add(new HttpHost(httpSSLEnabled ? "https" : "http", host, port));
    }

    public SecureRestClientBuilder(HttpHost[] httpHosts, boolean httpSSLEnabled, String user, String passWord) {
        if (Strings.isNullOrEmpty((String)user) || Strings.isNullOrEmpty((String)passWord)) {
            throw new IllegalArgumentException("Invalid user or password");
        }
        this.httpSSLEnabled = httpSSLEnabled;
        this.user = user;
        this.passwd = passWord;
        this.settings = Settings.EMPTY;
        this.configPath = null;
        this.hosts.addAll(Arrays.asList(httpHosts));
    }

    public SecureRestClientBuilder(Settings settings, Path configPath) {
        this.httpSSLEnabled = settings.getAsBoolean("plugins.security.ssl.http.enabled", Boolean.valueOf(false));
        this.settings = settings;
        this.configPath = configPath;
        this.user = null;
        this.passwd = null;
        int port = settings.getAsInt("http.port", Integer.valueOf(9200));
        this.hosts.add(new HttpHost(this.httpSSLEnabled ? "https" : "http", "localhost", port));
    }

    public SecureRestClientBuilder(Settings settings, Path configPath, HttpHost[] httpHosts) {
        this.httpSSLEnabled = settings.getAsBoolean("plugins.security.ssl.http.enabled", Boolean.valueOf(false));
        this.settings = settings;
        this.configPath = configPath;
        this.user = null;
        this.passwd = null;
        this.hosts.addAll(Arrays.asList(httpHosts));
    }

    public RestClient build() throws IOException {
        return this.createRestClientBuilder().build();
    }

    public SecureRestClientBuilder setConnectTimeout(int timeout) {
        this.defaultConnectTimeOutMSecs = timeout;
        return this;
    }

    public SecureRestClientBuilder setSocketTimeout(int timeout) {
        this.defaultSoTimeoutMSecs = timeout;
        return this;
    }

    public SecureRestClientBuilder setConnectionRequestTimeout(int timeout) {
        this.defaultConnRequestTimeoutMSecs = timeout;
        return this;
    }

    public SecureRestClientBuilder setMaxConnPerRoute(int maxConnPerRoute) {
        this.defaultMaxConnPerRoute = maxConnPerRoute;
        return this;
    }

    public SecureRestClientBuilder setMaxConnTotal(int maxConnTotal) {
        this.defaultMaxConnTotal = maxConnTotal;
        return this;
    }

    private RestClientBuilder createRestClientBuilder() throws IOException {
        SSLContext sslContext;
        RestClientBuilder builder = RestClient.builder(this.hosts.toArray(new HttpHost[this.hosts.size()]));
        builder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(Timeout.ofMilliseconds((long)this.defaultConnectTimeOutMSecs)).setResponseTimeout(Timeout.ofMilliseconds((long)this.defaultSoTimeoutMSecs)).setConnectionRequestTimeout(Timeout.ofMilliseconds((long)this.defaultConnRequestTimeoutMSecs)));
        try {
            sslContext = this.createSSLContext();
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new IOException(ex);
        }
        CredentialsProvider credentialsProvider = this.createCredsProvider();
        builder.setHttpClientConfigCallback(httpClientBuilder -> {
            if (sslContext != null) {
                TlsStrategy tlsStrategy = ClientTlsStrategyBuilder.create().setSslContext(sslContext).setTlsDetailsFactory(sslEngine -> new TlsDetails(sslEngine.getSession(), sslEngine.getApplicationProtocol())).build();
                PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(tlsStrategy).setMaxConnPerRoute(this.defaultMaxConnPerRoute).setMaxConnTotal(this.defaultMaxConnTotal).build();
                httpClientBuilder.setConnectionManager((AsyncClientConnectionManager)connectionManager);
            }
            if (credentialsProvider != null) {
                httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            }
            return httpClientBuilder;
        });
        return builder;
    }

    private SSLContext createSSLContext() throws IOException, GeneralSecurityException {
        SSLContextBuilder builder = new SSLContextBuilder();
        if (this.httpSSLEnabled) {
            KeyStore trustStore = this.getTrustStore();
            if (trustStore != null) {
                builder.loadTrustMaterial(trustStore, null);
            } else {
                String pemFile = this.getTrustPem();
                if (Strings.isNullOrEmpty((String)pemFile)) {
                    builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
                } else {
                    String pem = this.resolve(pemFile, this.configPath);
                    KeyStore pemTrustStore = new TrustStore(pem).createKeyStore();
                    builder.loadTrustMaterial(pemTrustStore, null);
                }
            }
            KeyStore keyStore = this.getKeyStore();
            if (keyStore != null) {
                String keyPassword = this.getKeyPassword();
                builder.loadKeyMaterial(keyStore, keyPassword.toCharArray());
            }
        }
        return builder.build();
    }

    private CredentialsProvider createCredsProvider() {
        if (Strings.isNullOrEmpty((String)this.user) || Strings.isNullOrEmpty((String)this.passwd)) {
            return null;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(null, -1), (Credentials)new UsernamePasswordCredentials(this.user, this.passwd.toCharArray()));
        return credentialsProvider;
    }

    private String resolve(String originalFile, Path configPath) {
        String path = null;
        if (originalFile != null && originalFile.length() > 0) {
            path = configPath.resolve(originalFile).toAbsolutePath().toString();
            log.debug("Resolved {} to {} against {}", (Object)originalFile, (Object)path, (Object)configPath.toAbsolutePath().toString());
        }
        if (path == null || path.length() == 0) {
            throw new SkyliteException("Empty file path for " + originalFile, new Object[0]);
        }
        if (Files.isDirectory(Paths.get(path, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            throw new SkyliteException("Is a directory: " + path + " Expected a file for " + originalFile, new Object[0]);
        }
        if (!Files.isReadable(Paths.get(path, new String[0]))) {
            throw new SkyliteException("Unable to read " + path + " (" + String.valueOf(Paths.get(path, new String[0])) + "). Please make sure this files exists and is readable regarding to permissions. Property: " + originalFile, new Object[0]);
        }
        if ("".equals(path)) {
            path = null;
        }
        return path;
    }

    private String getTrustPem() {
        return this.settings.get("plugins.security.ssl.http.pemcert_filepath", null);
    }

    private KeyStore getKeyStore() throws IOException, GeneralSecurityException {
        String keyStoreFile = this.settings.get("plugins.security.ssl.http.keystore_filepath", null);
        String passwd = ((SecureString)ConfigConstants.LUCENIA_SECURITY_SSL_HTTP_KEYSTORE_PASSWORD_SETTING.get(this.settings)).toString();
        if (Strings.isNullOrEmpty((String)keyStoreFile) || Strings.isNullOrEmpty((String)passwd)) {
            return null;
        }
        KeyStore keyStore = KeyStore.getInstance("jks");
        String keyStorePath = this.resolve(keyStoreFile, this.configPath);
        try (InputStream is = Files.newInputStream(Paths.get(keyStorePath, new String[0]), new OpenOption[0]);){
            keyStore.load(is, passwd.toCharArray());
        }
        return keyStore;
    }

    private KeyStore getTrustStore() throws IOException, GeneralSecurityException {
        String trustStoreFile = this.settings.get("plugins.security.ssl.http.truststore_filepath", null);
        String passwd = ((SecureString)ConfigConstants.LUCENIA_SECURITY_SSL_HTTP_TRUSTSTORE_PASSWORD_SETTING.get(this.settings)).toString();
        if (Strings.isNullOrEmpty((String)trustStoreFile) || Strings.isNullOrEmpty((String)passwd)) {
            return null;
        }
        KeyStore trustStore = KeyStore.getInstance("jks");
        String trustStorePath = this.resolve(trustStoreFile, this.configPath);
        try (InputStream is = Files.newInputStream(Paths.get(trustStorePath, new String[0]), new OpenOption[0]);){
            trustStore.load(is, passwd.toCharArray());
        }
        return trustStore;
    }

    private String getKeyPassword() {
        String keyPassword = ((SecureString)ConfigConstants.LUCENIA_SECURITY_SSL_HTTP_KEYSTORE_KEYPASSWORD_SETTING.get(this.settings)).toString();
        if (Strings.isNullOrEmpty((String)keyPassword)) {
            keyPassword = ((SecureString)ConfigConstants.LUCENIA_SECURITY_SSL_HTTP_KEYSTORE_PASSWORD_SETTING.get(this.settings)).toString();
        }
        return keyPassword;
    }
}

