/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ingest.geoip;

import com.maxmind.db.NoCache;
import com.maxmind.db.NodeCache;
import com.maxmind.db.Reader;
import com.maxmind.geoip2.DatabaseReader;
import io.lucenia.ingest.geoip.DatabaseReaderLazyLoader;
import io.lucenia.ingest.geoip.GeoIpProcessor;
import io.lucenia.plugins.Plugin;
import io.skylite.common.Booleans;
import io.skylite.common.CheckedSupplier;
import io.skylite.common.SuppressForbidden;
import io.skylite.common.cache.Cache;
import io.skylite.common.cache.CacheBuilder;
import io.skylite.common.io.PathUtils;
import io.skylite.common.processor.AbstractProcessor;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.ingest.IngestProcessor;
import io.skylite.core.plugins.IngestPlugin;
import io.skylite.core.settings.Setting;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public class IngestGeoIpModulePlugin
extends Plugin
implements IngestPlugin,
Closeable {
    public static final Setting<Long> CACHE_SIZE = Setting.longSetting((String)"ingest.geoip.cache_size", (long)1000L, (long)0L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static String[] DEFAULT_DATABASE_FILENAMES = new String[]{"GeoLite2-ASN.mmdb", "GeoLite2-City.mmdb", "GeoLite2-Country.mmdb"};
    private Map<String, DatabaseReaderLazyLoader> databaseReaders;

    public List<Setting<?>> getSettings() {
        return Arrays.asList(CACHE_SIZE);
    }

    public Map<String, AbstractProcessor.Factory<?>> getProcessors(IngestProcessor.Parameters parameters) {
        if (this.databaseReaders != null) {
            throw new IllegalStateException("getProcessors called twice for geoip plugin!!");
        }
        Path geoIpDirectory = this.getGeoIpDirectory(parameters);
        Path geoIpConfigDirectory = parameters.env.configDir().resolve("ingest-geoip");
        long cacheSize = (Long)CACHE_SIZE.get(parameters.env.settings());
        try {
            this.databaseReaders = IngestGeoIpModulePlugin.loadDatabaseReaders(geoIpDirectory, geoIpConfigDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Collections.singletonMap("geoip", new GeoIpProcessor.Factory(this.databaseReaders, new GeoIpCache(cacheSize)));
    }

    @SuppressForbidden(reason="PathUtils#get")
    private Path getGeoIpDirectory(IngestProcessor.Parameters parameters) {
        Path geoIpDirectory = parameters.env.settings().get("ingest.geoip.database_path") == null ? parameters.env.modulesDir().resolve("ingest-geoip") : PathUtils.get((String)parameters.env.settings().get("ingest.geoip.database_path"), (String[])new String[0]);
        return geoIpDirectory;
    }

    static Map<String, DatabaseReaderLazyLoader> loadDatabaseReaders(Path geoIpDirectory, Path geoIpConfigDirectory) throws IOException {
        DatabaseReaderLazyLoader loader;
        IngestGeoIpModulePlugin.assertDatabaseExistence(geoIpDirectory, true);
        IngestGeoIpModulePlugin.assertDatabaseExistence(geoIpConfigDirectory, false);
        boolean loadDatabaseOnHeap = Booleans.parseBoolean((String)System.getProperty("opensearch.geoip.load_db_on_heap", "false"));
        HashMap<String, DatabaseReaderLazyLoader> databaseReaders = new HashMap<String, DatabaseReaderLazyLoader>();
        for (String databaseFilename : DEFAULT_DATABASE_FILENAMES) {
            Path databasePath = geoIpDirectory.resolve(databaseFilename);
            loader = IngestGeoIpModulePlugin.createLoader(databasePath, loadDatabaseOnHeap);
            databaseReaders.put(databaseFilename, loader);
        }
        if (Files.exists(geoIpConfigDirectory, new LinkOption[0])) {
            try (Stream<Path> databaseFiles = Files.list(geoIpConfigDirectory);){
                PathMatcher pathMatcher = geoIpConfigDirectory.getFileSystem().getPathMatcher("glob:**.mmdb");
                Iterator iterator = databaseFiles.iterator();
                while (iterator.hasNext()) {
                    Path databasePath = (Path)iterator.next();
                    if (!Files.isRegularFile(databasePath, new LinkOption[0]) || !pathMatcher.matches(databasePath)) continue;
                    String databaseFileName = databasePath.getFileName().toString();
                    loader = IngestGeoIpModulePlugin.createLoader(databasePath, loadDatabaseOnHeap);
                    databaseReaders.put(databaseFileName, loader);
                }
            }
        }
        return Collections.unmodifiableMap(databaseReaders);
    }

    private static DatabaseReaderLazyLoader createLoader(Path databasePath, boolean loadDatabaseOnHeap) {
        return new DatabaseReaderLazyLoader(databasePath, (CheckedSupplier<DatabaseReader, IOException>)((CheckedSupplier)() -> {
            DatabaseReader.Builder builder = IngestGeoIpModulePlugin.createDatabaseBuilder(databasePath).withCache((NodeCache)NoCache.getInstance());
            if (loadDatabaseOnHeap) {
                builder.fileMode(Reader.FileMode.MEMORY);
            } else {
                builder.fileMode(Reader.FileMode.MEMORY_MAPPED);
            }
            return builder.build();
        }));
    }

    private static void assertDatabaseExistence(Path path, boolean exists) throws IOException {
        for (String database : DEFAULT_DATABASE_FILENAMES) {
            if (Files.exists(path.resolve(database), new LinkOption[0]) == exists) continue;
            String message = "expected database [" + database + "] to " + (exists ? "" : "not ") + "exist in [" + String.valueOf(path) + "]";
            throw new IOException(message);
        }
    }

    @SuppressForbidden(reason="Maxmind API requires java.io.File")
    private static DatabaseReader.Builder createDatabaseBuilder(Path databasePath) {
        return new DatabaseReader.Builder(databasePath.toFile());
    }

    @Override
    public void close() throws IOException {
        if (this.databaseReaders != null) {
            IOUtils.close(this.databaseReaders.values());
        }
    }

    static class GeoIpCache {
        private final Cache<CacheKey<?>, Record> cache;

        GeoIpCache(long maxSize) {
            if (maxSize < 0L) {
                throw new IllegalArgumentException("geoip max cache size must be 0 or greater");
            }
            this.cache = CacheBuilder.builder().setMaximumWeight(maxSize).build();
        }

        <T extends Record> T putIfAbsent(InetAddress ip, Class<T> responseType, Function<InetAddress, Record> retrieveFunction) {
            CacheKey<T> cacheKey = new CacheKey<T>(ip, responseType);
            Record response = (Record)this.cache.get(cacheKey);
            if (response == null) {
                response = retrieveFunction.apply(ip);
                this.cache.put(cacheKey, (Object)response);
            }
            return (T)((Record)responseType.cast(response));
        }

        <T extends Record> T get(InetAddress ip, Class<T> responseType) {
            CacheKey<T> cacheKey = new CacheKey<T>(ip, responseType);
            return (T)((Record)responseType.cast(this.cache.get(cacheKey)));
        }

        private static class CacheKey<T extends Record> {
            private final InetAddress ip;
            private final Class<T> responseType;

            private CacheKey(InetAddress ip, Class<T> responseType) {
                this.ip = ip;
                this.responseType = responseType;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                CacheKey cacheKey = (CacheKey)o;
                return Objects.equals(this.ip, cacheKey.ip) && Objects.equals(this.responseType, cacheKey.responseType);
            }

            public int hashCode() {
                return Objects.hash(this.ip, this.responseType);
            }
        }
    }
}

