/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement;

import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ActionMetaData;
import io.skylite.indexmanagement.model.ActionRetry;
import io.skylite.indexmanagement.model.ActionTimeout;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.PolicyRetryInfoMetaData;
import io.skylite.indexmanagement.model.StateMetaData;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;
import java.io.IOException;
import java.time.Instant;
import java.util.List;

public abstract class Action
implements ToXContentObject,
Writeable {
    public static final long DEFAULT_RETRIES = 3L;
    public static final String CUSTOM_ACTION_FIELD = "custom";
    public static final String EXCLUDE_CUSTOM_FIELD_PARAM = "exclude_custom";
    private final String type;
    private final int actionIndex;
    private ActionTimeout configTimeout;
    private ActionRetry configRetry;
    private boolean customAction;

    public Action(String type, int actionIndex) {
        this.type = type;
        this.actionIndex = actionIndex;
        this.configTimeout = null;
        this.configRetry = new ActionRetry(3L);
        this.customAction = false;
    }

    public String getType() {
        return this.type;
    }

    public int getActionIndex() {
        return this.actionIndex;
    }

    public ActionTimeout getConfigTimeout() {
        return this.configTimeout;
    }

    public void setConfigTimeout(ActionTimeout configTimeout) {
        this.configTimeout = configTimeout;
    }

    public ActionRetry getConfigRetry() {
        return this.configRetry;
    }

    public void setConfigRetry(ActionRetry configRetry) {
        this.configRetry = configRetry;
    }

    public boolean isCustomAction() {
        return this.customAction;
    }

    public void setCustomAction(boolean customAction) {
        this.customAction = customAction;
    }

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.configTimeout != null) {
            this.configTimeout.toXContent(builder, params);
        }
        if (this.configRetry != null) {
            this.configRetry.toXContent(builder, params);
        }
        if (this.customAction && !params.paramAsBoolean(EXCLUDE_CUSTOM_FIELD_PARAM, false)) {
            builder.startObject(CUSTOM_ACTION_FIELD);
        }
        this.populateAction(builder, params);
        if (this.customAction && !params.paramAsBoolean(EXCLUDE_CUSTOM_FIELD_PARAM, false)) {
            builder.endObject();
        }
        return builder.endObject();
    }

    public void populateAction(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.type).endObject();
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        out.writeOptionalWriteable((Writeable)this.configTimeout);
        out.writeOptionalWriteable((Writeable)this.configRetry);
        this.populateAction(out);
    }

    public ActionMetaData getUpdatedActionMetadata(ManagedIndexMetaData managedIndexMetaData, String stateName) {
        StateMetaData stateMetaData = managedIndexMetaData.getStateMetaData();
        ActionMetaData actionMetaData = managedIndexMetaData.getActionMetaData();
        if (stateMetaData == null || !stateMetaData.getName().equals(stateName)) {
            return new ActionMetaData(this.type, Instant.now().toEpochMilli(), this.actionIndex, false, 0, 0L, null);
        }
        if (actionMetaData == null || actionMetaData.getIndex() != this.actionIndex) {
            return new ActionMetaData(this.type, Instant.now().toEpochMilli(), this.actionIndex, false, 0, 0L, null);
        }
        Long startTime = actionMetaData.getStartTime() != null ? actionMetaData.getStartTime().longValue() : Instant.now().toEpochMilli();
        return actionMetaData.copy(startTime);
    }

    public void populateAction(StreamOutput out) throws IOException {
        out.writeInt(this.actionIndex);
    }

    public abstract List<Step> getSteps();

    public abstract Step getStepToExecute(StepContext var1);

    public final boolean isLastStep(String stepName) {
        List<Step> steps = this.getSteps();
        return !steps.isEmpty() && steps.get(steps.size() - 1).getName().equals(stepName);
    }

    public final boolean isFirstStep(String stepName) {
        List<Step> steps = this.getSteps();
        return !steps.isEmpty() && steps.get(0).getName().equals(stepName);
    }

    public final boolean isFinishedSuccessfully(ManagedIndexMetaData managedIndexMetaData) {
        PolicyRetryInfoMetaData policyRetryInfo = managedIndexMetaData.getPolicyRetryInfo();
        if (policyRetryInfo != null && policyRetryInfo.getFailed()) {
            return false;
        }
        ActionMetaData actionMetaData = managedIndexMetaData.getActionMetaData();
        if (actionMetaData == null || actionMetaData.getFailed() || !actionMetaData.getName().equals(this.type)) {
            return false;
        }
        StepMetaData stepMetaData = managedIndexMetaData.getStepMetaData();
        return stepMetaData != null && this.isLastStep(stepMetaData.getName()) && stepMetaData.getStepStatus() == Step.StepStatus.COMPLETED;
    }

    public boolean deleteIndexMetadataAfterFinish() {
        return false;
    }
}

