/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.indexmanagement.metrics.ActionMetrics;
import io.skylite.indexmanagement.metrics.IndexManagementActionsMetrics;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;
import java.io.IOException;
import java.time.Instant;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.Logger;

public abstract class Step {
    private final String name;
    private final boolean isSafeToDisableOn;
    private StepContext context;

    public Step(String name) {
        this(name, true);
    }

    public Step(String name, boolean isSafeToDisableOn) {
        this.name = name;
        this.isSafeToDisableOn = isSafeToDisableOn;
        this.context = null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSafeToDisableOn() {
        return this.isSafeToDisableOn;
    }

    protected StepContext getContext() {
        return this.context;
    }

    public Step preExecute(Logger logger, StepContext context) {
        logger.info("Executing " + this.name + " for " + context.getMetadata().getIndex());
        this.context = context;
        return this;
    }

    public abstract CompletableFuture<Step> execute();

    public Step postExecute(Logger logger, IndexManagementActionsMetrics indexManagementActionMetrics, Step step, ManagedIndexMetaData startingManagedIndexMetaData) {
        logger.info("Finished executing " + this.name + " for " + (this.context != null ? this.context.getMetadata().getIndex() : ""));
        ManagedIndexMetaData updatedStepMetaData = step.getUpdatedManagedIndexMetadata(startingManagedIndexMetaData);
        this.emitTelemetry(indexManagementActionMetrics, updatedStepMetaData, logger);
        this.context = null;
        return this;
    }

    private void emitTelemetry(IndexManagementActionsMetrics indexManagementActionMetrics, ManagedIndexMetaData updatedStepMetaData, Logger logger) {
        if (this.context == null || this.context.getMetadata() == null || this.context.getMetadata().getActionMetaData() == null) {
            return;
        }
        String actionName = this.context.getMetadata().getActionMetaData().getName();
        if (actionName == null) {
            return;
        }
        switch (actionName) {
            case "rollover": {
                this.emitMetricsForAction(indexManagementActionMetrics, "rollover", updatedStepMetaData);
                break;
            }
            case "force_merge": {
                this.emitMetricsForAction(indexManagementActionMetrics, "force_merge", updatedStepMetaData);
                break;
            }
            case "delete": {
                this.emitMetricsForAction(indexManagementActionMetrics, "delete", updatedStepMetaData);
                break;
            }
            case "replica_count": {
                this.emitMetricsForAction(indexManagementActionMetrics, "replica_count", updatedStepMetaData);
                break;
            }
            case "transition": {
                this.emitMetricsForAction(indexManagementActionMetrics, "transition", updatedStepMetaData);
                break;
            }
            case "notification": {
                this.emitMetricsForAction(indexManagementActionMetrics, "notification", updatedStepMetaData);
                break;
            }
            case "close": {
                this.emitMetricsForAction(indexManagementActionMetrics, "close", updatedStepMetaData);
                break;
            }
            case "set_index_priority": {
                this.emitMetricsForAction(indexManagementActionMetrics, "set_index_priority", updatedStepMetaData);
                break;
            }
            case "open": {
                this.emitMetricsForAction(indexManagementActionMetrics, "open", updatedStepMetaData);
                break;
            }
            case "move_shard": {
                this.emitMetricsForAction(indexManagementActionMetrics, "move_shard", updatedStepMetaData);
                break;
            }
            case "set_read_only": {
                this.emitMetricsForAction(indexManagementActionMetrics, "set_read_only", updatedStepMetaData);
                break;
            }
            case "shrink": {
                this.emitMetricsForAction(indexManagementActionMetrics, "shrink", updatedStepMetaData);
                break;
            }
            case "snapshot": {
                this.emitMetricsForAction(indexManagementActionMetrics, "snapshot", updatedStepMetaData);
                break;
            }
            case "alias_action": {
                this.emitMetricsForAction(indexManagementActionMetrics, "alias_action", updatedStepMetaData);
                break;
            }
            case "allocation": {
                this.emitMetricsForAction(indexManagementActionMetrics, "allocation", updatedStepMetaData);
                break;
            }
            default: {
                logger.info("Action Metrics is not supported for this action [" + actionName + "]");
            }
        }
    }

    private void emitMetricsForAction(IndexManagementActionsMetrics indexManagementActionMetrics, String actionName, ManagedIndexMetaData updatedStepMetaData) {
        ActionMetrics actionMetrics = indexManagementActionMetrics.getActionMetrics(actionName);
        if (actionMetrics != null && this.context != null) {
            actionMetrics.emitMetrics(this.context, indexManagementActionMetrics, updatedStepMetaData.getStepMetaData());
        }
    }

    public abstract ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData var1);

    public abstract boolean isIdempotent();

    public final Instant getStepStartTime(ManagedIndexMetaData metadata) {
        if (metadata.getStepMetaData() == null) {
            return Instant.now();
        }
        if (!metadata.getStepMetaData().getName().equals(this.name)) {
            return Instant.now();
        }
        if (metadata.getStepMetaData().getStepStatus() == StepStatus.COMPLETED) {
            return Instant.now();
        }
        return Instant.ofEpochMilli(metadata.getStepMetaData().getStartTime());
    }

    public final StepMetaData getStartingStepMetaData(ManagedIndexMetaData metadata) {
        return new StepMetaData(this.name, this.getStepStartTime(metadata).toEpochMilli(), StepStatus.STARTING);
    }

    public static enum StepStatus implements Writeable
    {
        STARTING("starting"),
        CONDITION_NOT_MET("condition_not_met"),
        FAILED("failed"),
        COMPLETED("completed"),
        TIMED_OUT("timed_out");

        private final String status;

        private StepStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public String toString() {
            return this.status;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.status);
        }

        public static StepStatus read(StreamInput streamInput) throws IOException {
            return StepStatus.valueOf(streamInput.readString().toUpperCase(Locale.ROOT));
        }
    }
}

