/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement;

import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.monitor.jvm.JvmService;
import io.skylite.core.settings.Settings;
import java.io.IOException;
import java.util.Locale;

public abstract class Validate {
    private final Settings settings;
    private final ClusterService clusterService;
    private final JvmService jvmService;
    private ValidationStatus validationStatus = ValidationStatus.PASSED;
    private String validationMessage = "Starting Validation";

    public Validate(Settings settings, ClusterService clusterService, JvmService jvmService) {
        this.settings = settings;
        this.clusterService = clusterService;
        this.jvmService = jvmService;
    }

    public abstract Validate execute(String var1);

    public Settings getSettings() {
        return this.settings;
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    public JvmService getJvmService() {
        return this.jvmService;
    }

    public ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    public void setValidationStatus(ValidationStatus validationStatus) {
        this.validationStatus = validationStatus;
    }

    public String getValidationMessage() {
        return this.validationMessage;
    }

    public void setValidationMessage(String validationMessage) {
        this.validationMessage = validationMessage;
    }

    public static enum ValidationStatus implements Writeable
    {
        PASSED("passed"),
        RE_VALIDATING("re_validating"),
        FAILED("failed");

        private final String status;

        private ValidationStatus(String status) {
            this.status = status;
        }

        public String toString() {
            return this.status;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.status);
        }

        public static ValidationStatus read(StreamInput streamInput) throws IOException {
            return ValidationStatus.valueOf(streamInput.readString().toUpperCase(Locale.ROOT));
        }

        public String getStatus() {
            return this.status;
        }
    }
}

