/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.metrics;

import io.skylite.core.telemetry.metrics.MetricsRegistry;
import io.skylite.indexmanagement.metrics.ActionMetrics;
import io.skylite.indexmanagement.metrics.actionmetrics.AliasActionMetrics;
import io.skylite.indexmanagement.metrics.actionmetrics.AllocationActionMetrics;
import io.skylite.indexmanagement.metrics.actionmetrics.CloseActionMetrics;
import io.skylite.indexmanagement.metrics.actionmetrics.DeleteActionMetrics;
import io.skylite.indexmanagement.metrics.actionmetrics.ForceMergeActionMetrics;
import io.skylite.indexmanagement.metrics.actionmetrics.MoveShardActionMetrics;
import io.skylite.indexmanagement.metrics.actionmetrics.NotificationActionMetrics;
import io.skylite.indexmanagement.metrics.actionmetrics.OpenActionMetrics;
import io.skylite.indexmanagement.metrics.actionmetrics.ReplicaCountActionMetrics;
import io.skylite.indexmanagement.metrics.actionmetrics.RolloverActionMetrics;
import io.skylite.indexmanagement.metrics.actionmetrics.SetIndexPriorityActionMetrics;
import io.skylite.indexmanagement.metrics.actionmetrics.SetReadOnlyActionMetrics;
import io.skylite.indexmanagement.metrics.actionmetrics.ShrinkActionMetrics;
import io.skylite.indexmanagement.metrics.actionmetrics.SnapshotActionMetrics;
import io.skylite.indexmanagement.metrics.actionmetrics.TransitionActionMetrics;
import java.util.HashMap;
import java.util.Map;

public class IndexManagementActionsMetrics {
    private MetricsRegistry metricsRegistry;
    private Map<String, ActionMetrics> actionMetricsMap;
    public static final String ROLLOVER = "rollover";
    public static final String NOTIFICATION = "notification";
    public static final String FORCE_MERGE = "force_merge";
    public static final String DELETE = "delete";
    public static final String REPLICA_COUNT = "replica_count";
    public static final String TRANSITION = "transition";
    public static final String CLOSE = "close";
    public static final String SET_INDEX_PRIORITY = "set_index_priority";
    public static final String OPEN = "open";
    public static final String MOVE_SHARD = "move_shard";
    public static final String SET_READ_ONLY = "set_read_only";
    public static final String SHRINK = "shrink";
    public static final String SNAPSHOT = "snapshot";
    public static final String ALIAS_ACTION = "alias_action";
    public static final String ALLOCATION = "allocation";

    private IndexManagementActionsMetrics() {
    }

    public static IndexManagementActionsMetrics getInstance() {
        return Holder.INSTANCE;
    }

    public void initialize(MetricsRegistry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
        RolloverActionMetrics.getInstance().initializeCounters(metricsRegistry);
        NotificationActionMetrics.getInstance().initializeCounters(metricsRegistry);
        ForceMergeActionMetrics.getInstance().initializeCounters(metricsRegistry);
        DeleteActionMetrics.getInstance().initializeCounters(metricsRegistry);
        ReplicaCountActionMetrics.getInstance().initializeCounters(metricsRegistry);
        TransitionActionMetrics.getInstance().initializeCounters(metricsRegistry);
        CloseActionMetrics.getInstance().initializeCounters(metricsRegistry);
        SetIndexPriorityActionMetrics.getInstance().initializeCounters(metricsRegistry);
        OpenActionMetrics.getInstance().initializeCounters(metricsRegistry);
        MoveShardActionMetrics.getInstance().initializeCounters(metricsRegistry);
        SetReadOnlyActionMetrics.getInstance().initializeCounters(metricsRegistry);
        ShrinkActionMetrics.getInstance().initializeCounters(metricsRegistry);
        SnapshotActionMetrics.getInstance().initializeCounters(metricsRegistry);
        AliasActionMetrics.getInstance().initializeCounters(metricsRegistry);
        AllocationActionMetrics.getInstance().initializeCounters(metricsRegistry);
        this.actionMetricsMap = new HashMap<String, ActionMetrics>();
        this.actionMetricsMap.put(ROLLOVER, RolloverActionMetrics.getInstance());
        this.actionMetricsMap.put(NOTIFICATION, NotificationActionMetrics.getInstance());
        this.actionMetricsMap.put(FORCE_MERGE, ForceMergeActionMetrics.getInstance());
        this.actionMetricsMap.put(DELETE, DeleteActionMetrics.getInstance());
        this.actionMetricsMap.put(REPLICA_COUNT, ReplicaCountActionMetrics.getInstance());
        this.actionMetricsMap.put(TRANSITION, TransitionActionMetrics.getInstance());
        this.actionMetricsMap.put(CLOSE, CloseActionMetrics.getInstance());
        this.actionMetricsMap.put(SET_INDEX_PRIORITY, SetIndexPriorityActionMetrics.getInstance());
        this.actionMetricsMap.put(OPEN, OpenActionMetrics.getInstance());
        this.actionMetricsMap.put(MOVE_SHARD, MoveShardActionMetrics.getInstance());
        this.actionMetricsMap.put(SET_READ_ONLY, SetReadOnlyActionMetrics.getInstance());
        this.actionMetricsMap.put(SHRINK, ShrinkActionMetrics.getInstance());
        this.actionMetricsMap.put(SNAPSHOT, SnapshotActionMetrics.getInstance());
        this.actionMetricsMap.put(ALIAS_ACTION, AliasActionMetrics.getInstance());
        this.actionMetricsMap.put(ALLOCATION, AllocationActionMetrics.getInstance());
    }

    public ActionMetrics getActionMetrics(String actionName) {
        return this.actionMetricsMap.get(actionName);
    }

    private static class Holder {
        private static final IndexManagementActionsMetrics INSTANCE = new IndexManagementActionsMetrics();

        private Holder() {
        }
    }
}

