/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.metrics.actionmetrics;

import io.skylite.core.telemetry.metrics.Counter;
import io.skylite.core.telemetry.metrics.MetricsRegistry;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.metrics.ActionMetrics;
import io.skylite.indexmanagement.metrics.IndexManagementActionsMetrics;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;

public class AllocationActionMetrics
extends ActionMetrics {
    private Counter successes;
    private Counter failures;
    private Counter cumulativeLatency;

    private AllocationActionMetrics() {
    }

    public static AllocationActionMetrics getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public String getActionName() {
        return "allocation";
    }

    public void initializeCounters(MetricsRegistry metricsRegistry) {
        this.successes = metricsRegistry.createCounter(this.getActionName() + "_successes", "Allocation Action Successes", "count");
        this.failures = metricsRegistry.createCounter(this.getActionName() + "_failures", "Allocation Action Failures", "count");
        this.cumulativeLatency = metricsRegistry.createCounter(this.getActionName() + "_cumulative_latency", "Cumulative Latency of Allocation Actions", "milliseconds");
    }

    @Override
    public void emitMetrics(StepContext context, IndexManagementActionsMetrics indexManagementActionsMetrics, StepMetaData stepMetaData) {
        Step.StepStatus stepStatus;
        AllocationActionMetrics allocationActionMetrics = (AllocationActionMetrics)indexManagementActionsMetrics.getActionMetrics("allocation");
        Step.StepStatus stepStatus2 = stepStatus = stepMetaData != null ? stepMetaData.getStepStatus() : null;
        if (stepStatus == Step.StepStatus.COMPLETED) {
            allocationActionMetrics.successes.add(1.0, allocationActionMetrics.createTags(context));
        }
        if (stepStatus == Step.StepStatus.FAILED) {
            allocationActionMetrics.failures.add(1.0, allocationActionMetrics.createTags(context));
        }
        long endTime = System.currentTimeMillis();
        Long startTime = context.getMetadata().getStepMetaData() != null ? Long.valueOf(context.getMetadata().getStepMetaData().getStartTime()) : null;
        long latency = endTime - (startTime != null ? startTime : endTime);
        allocationActionMetrics.cumulativeLatency.add((double)latency, allocationActionMetrics.createTags(context));
    }

    private static class Holder {
        private static final AllocationActionMetrics INSTANCE = new AllocationActionMetrics();

        private Holder() {
        }
    }
}

