/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.metrics.actionmetrics;

import io.skylite.core.telemetry.metrics.Counter;
import io.skylite.core.telemetry.metrics.MetricsRegistry;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.metrics.ActionMetrics;
import io.skylite.indexmanagement.metrics.IndexManagementActionsMetrics;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;

public class ForceMergeActionMetrics
extends ActionMetrics {
    private Counter successes;
    private Counter failures;
    private Counter cumulativeLatency;

    private ForceMergeActionMetrics() {
    }

    public static ForceMergeActionMetrics getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public String getActionName() {
        return "force_merge";
    }

    public void initializeCounters(MetricsRegistry metricsRegistry) {
        this.successes = metricsRegistry.createCounter(this.getActionName() + "_successes", "Force Merge Action Successes", "count");
        this.failures = metricsRegistry.createCounter(this.getActionName() + "_failures", "Force Merge Action Failures", "count");
        this.cumulativeLatency = metricsRegistry.createCounter(this.getActionName() + "_cumulative_latency", "Cumulative Latency of Force Merge Action", "milliseconds");
    }

    @Override
    public void emitMetrics(StepContext context, IndexManagementActionsMetrics indexManagementActionsMetrics, StepMetaData stepMetaData) {
        Step.StepStatus stepStatus;
        ForceMergeActionMetrics forceMergeActionMetrics = (ForceMergeActionMetrics)indexManagementActionsMetrics.getActionMetrics("force_merge");
        Step.StepStatus stepStatus2 = stepStatus = stepMetaData != null ? stepMetaData.getStepStatus() : null;
        if (stepStatus == Step.StepStatus.COMPLETED) {
            forceMergeActionMetrics.successes.add(1.0, forceMergeActionMetrics.createTags(context));
        }
        if (stepStatus == Step.StepStatus.FAILED) {
            forceMergeActionMetrics.failures.add(1.0, forceMergeActionMetrics.createTags(context));
        }
        long endTime = System.currentTimeMillis();
        Long startTime = context.getMetadata().getStepMetaData() != null ? Long.valueOf(context.getMetadata().getStepMetaData().getStartTime()) : null;
        long latency = endTime - (startTime != null ? startTime : endTime);
        forceMergeActionMetrics.cumulativeLatency.add((double)latency, forceMergeActionMetrics.createTags(context));
    }

    private static class Holder {
        private static final ForceMergeActionMetrics INSTANCE = new ForceMergeActionMetrics();

        private Holder() {
        }
    }
}

