/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.metrics.actionmetrics;

import io.skylite.core.telemetry.metrics.Counter;
import io.skylite.core.telemetry.metrics.MetricsRegistry;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.metrics.ActionMetrics;
import io.skylite.indexmanagement.metrics.IndexManagementActionsMetrics;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;

public class MoveShardActionMetrics
extends ActionMetrics {
    private Counter successes;
    private Counter failures;
    private Counter cumulativeLatency;

    private MoveShardActionMetrics() {
    }

    public static MoveShardActionMetrics getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public String getActionName() {
        return "move_shard";
    }

    public void initializeCounters(MetricsRegistry metricsRegistry) {
        this.successes = metricsRegistry.createCounter(this.getActionName() + "_successes", "Move Shard Action Successes", "count");
        this.failures = metricsRegistry.createCounter(this.getActionName() + "_failures", "Move Shard Action Failures", "count");
        this.cumulativeLatency = metricsRegistry.createCounter(this.getActionName() + "_cumulative_latency", "Cumulative Latency of Move Shard Actions", "milliseconds");
    }

    @Override
    public void emitMetrics(StepContext context, IndexManagementActionsMetrics indexManagementActionsMetrics, StepMetaData stepMetaData) {
        Step.StepStatus stepStatus;
        MoveShardActionMetrics moveShardActionMetrics = (MoveShardActionMetrics)indexManagementActionsMetrics.getActionMetrics("move_shard");
        Step.StepStatus stepStatus2 = stepStatus = stepMetaData != null ? stepMetaData.getStepStatus() : null;
        if (stepStatus == Step.StepStatus.COMPLETED) {
            moveShardActionMetrics.successes.add(1.0, moveShardActionMetrics.createTags(context));
        }
        if (stepStatus == Step.StepStatus.FAILED) {
            moveShardActionMetrics.failures.add(1.0, moveShardActionMetrics.createTags(context));
        }
        long endTime = System.currentTimeMillis();
        Long startTime = context.getMetadata().getStepMetaData() != null ? Long.valueOf(context.getMetadata().getStepMetaData().getStartTime()) : null;
        long latency = endTime - (startTime != null ? startTime : endTime);
        moveShardActionMetrics.cumulativeLatency.add((double)latency, moveShardActionMetrics.createTags(context));
    }

    private static class Holder {
        private static final MoveShardActionMetrics INSTANCE = new MoveShardActionMetrics();

        private Holder() {
        }
    }
}

