/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.metrics.actionmetrics;

import io.skylite.core.telemetry.metrics.Counter;
import io.skylite.core.telemetry.metrics.MetricsRegistry;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.metrics.ActionMetrics;
import io.skylite.indexmanagement.metrics.IndexManagementActionsMetrics;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;

public class NotificationActionMetrics
extends ActionMetrics {
    private Counter successes;
    private Counter failures;
    private Counter cumulativeLatency;

    private NotificationActionMetrics() {
    }

    public static NotificationActionMetrics getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public String getActionName() {
        return "notification";
    }

    public void initializeCounters(MetricsRegistry metricsRegistry) {
        this.successes = metricsRegistry.createCounter(this.getActionName() + "_successes", "Notification Action Successes", "count");
        this.failures = metricsRegistry.createCounter(this.getActionName() + "_failures", "Notification Action Failures", "count");
        this.cumulativeLatency = metricsRegistry.createCounter(this.getActionName() + "_cumulative_latency", "Cumulative Latency of Notification Action", "milliseconds");
    }

    @Override
    public void emitMetrics(StepContext context, IndexManagementActionsMetrics indexManagementActionsMetrics, StepMetaData stepMetaData) {
        Step.StepStatus stepStatus;
        NotificationActionMetrics notificationActionMetrics = (NotificationActionMetrics)indexManagementActionsMetrics.getActionMetrics("notification");
        Step.StepStatus stepStatus2 = stepStatus = stepMetaData != null ? stepMetaData.getStepStatus() : null;
        if (stepStatus == Step.StepStatus.COMPLETED) {
            notificationActionMetrics.successes.add(1.0, notificationActionMetrics.createTags(context));
        }
        if (stepStatus == Step.StepStatus.FAILED) {
            notificationActionMetrics.failures.add(1.0, notificationActionMetrics.createTags(context));
        }
        long endTime = System.currentTimeMillis();
        Long startTime = context.getMetadata().getStepMetaData() != null ? Long.valueOf(context.getMetadata().getStepMetaData().getStartTime()) : null;
        long latency = endTime - (startTime != null ? startTime : endTime);
        notificationActionMetrics.cumulativeLatency.add((double)latency, notificationActionMetrics.createTags(context));
    }

    private static class Holder {
        private static final NotificationActionMetrics INSTANCE = new NotificationActionMetrics();

        private Holder() {
        }
    }
}

