/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.metrics.actionmetrics;

import io.skylite.core.telemetry.metrics.Counter;
import io.skylite.core.telemetry.metrics.MetricsRegistry;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.metrics.ActionMetrics;
import io.skylite.indexmanagement.metrics.IndexManagementActionsMetrics;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;

public class OpenActionMetrics
extends ActionMetrics {
    private Counter successes;
    private Counter failures;
    private Counter cumulativeLatency;

    public Counter getSuccesses() {
        return this.successes;
    }

    public Counter getFailures() {
        return this.failures;
    }

    private OpenActionMetrics() {
    }

    public static OpenActionMetrics getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public String getActionName() {
        return "open";
    }

    public void initializeCounters(MetricsRegistry metricsRegistry) {
        this.successes = metricsRegistry.createCounter(this.getActionName() + "_successes", "Open Action Successes", "count");
        this.failures = metricsRegistry.createCounter(this.getActionName() + "_failures", "Open Action Failures", "count");
        this.cumulativeLatency = metricsRegistry.createCounter(this.getActionName() + "_cumulative_latency", "Cumulative Latency of Open Actions", "milliseconds");
    }

    @Override
    public void emitMetrics(StepContext context, IndexManagementActionsMetrics indexManagementActionsMetrics, StepMetaData stepMetaData) {
        Step.StepStatus stepStatus;
        OpenActionMetrics openActionMetrics = (OpenActionMetrics)indexManagementActionsMetrics.getActionMetrics("open");
        Step.StepStatus stepStatus2 = stepStatus = stepMetaData != null ? stepMetaData.getStepStatus() : null;
        if (stepStatus == Step.StepStatus.COMPLETED) {
            openActionMetrics.successes.add(1.0, openActionMetrics.createTags(context));
        }
        if (stepStatus == Step.StepStatus.FAILED) {
            openActionMetrics.failures.add(1.0, openActionMetrics.createTags(context));
        }
        long endTime = System.currentTimeMillis();
        Long startTime = context.getMetadata().getStepMetaData() != null ? Long.valueOf(context.getMetadata().getStepMetaData().getStartTime()) : null;
        long latency = endTime - (startTime != null ? startTime : endTime);
        openActionMetrics.cumulativeLatency.add((double)latency, openActionMetrics.createTags(context));
    }

    private static class Holder {
        private static final OpenActionMetrics INSTANCE = new OpenActionMetrics();

        private Holder() {
        }
    }
}

