/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.metrics.actionmetrics;

import io.skylite.core.telemetry.metrics.Counter;
import io.skylite.core.telemetry.metrics.MetricsRegistry;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.metrics.ActionMetrics;
import io.skylite.indexmanagement.metrics.IndexManagementActionsMetrics;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;

public class ReplicaCountActionMetrics
extends ActionMetrics {
    private Counter successes;
    private Counter failures;
    private Counter cumulativeLatency;

    public Counter getSuccesses() {
        return this.successes;
    }

    public Counter getFailures() {
        return this.failures;
    }

    private ReplicaCountActionMetrics() {
    }

    public static ReplicaCountActionMetrics getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public String getActionName() {
        return "replica_count";
    }

    public void initializeCounters(MetricsRegistry metricsRegistry) {
        this.successes = metricsRegistry.createCounter(this.getActionName() + "_successes", "Replica Action Successes", "count");
        this.failures = metricsRegistry.createCounter(this.getActionName() + "_failures", "Replica Action Failures", "count");
        this.cumulativeLatency = metricsRegistry.createCounter(this.getActionName() + "_cumulative_latency", "Cumulative Latency of Replica Count Action", "milliseconds");
    }

    @Override
    public void emitMetrics(StepContext context, IndexManagementActionsMetrics indexManagementActionsMetrics, StepMetaData stepMetaData) {
        Step.StepStatus stepStatus;
        ReplicaCountActionMetrics replicaCountActionMetrics = (ReplicaCountActionMetrics)indexManagementActionsMetrics.getActionMetrics("replica_count");
        Step.StepStatus stepStatus2 = stepStatus = stepMetaData != null ? stepMetaData.getStepStatus() : null;
        if (stepStatus == Step.StepStatus.COMPLETED) {
            replicaCountActionMetrics.successes.add(1.0, replicaCountActionMetrics.createTags(context));
        }
        if (stepStatus == Step.StepStatus.FAILED) {
            replicaCountActionMetrics.failures.add(1.0, replicaCountActionMetrics.createTags(context));
        }
        long endTime = System.currentTimeMillis();
        Long startTime = context.getMetadata().getStepMetaData() != null ? Long.valueOf(context.getMetadata().getStepMetaData().getStartTime()) : null;
        long latency = endTime - (startTime != null ? startTime : endTime);
        replicaCountActionMetrics.cumulativeLatency.add((double)latency, replicaCountActionMetrics.createTags(context));
    }

    private static class Holder {
        private static final ReplicaCountActionMetrics INSTANCE = new ReplicaCountActionMetrics();

        private Holder() {
        }
    }
}

