/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.metrics.actionmetrics;

import io.skylite.core.telemetry.metrics.Counter;
import io.skylite.core.telemetry.metrics.MetricsRegistry;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.metrics.ActionMetrics;
import io.skylite.indexmanagement.metrics.IndexManagementActionsMetrics;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;

public class RolloverActionMetrics
extends ActionMetrics {
    private Counter successes;
    private Counter failures;
    private Counter cumulativeLatency;

    public Counter getSuccesses() {
        return this.successes;
    }

    public Counter getFailures() {
        return this.failures;
    }

    private RolloverActionMetrics() {
    }

    public static RolloverActionMetrics getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public String getActionName() {
        return "rollover";
    }

    public void initializeCounters(MetricsRegistry metricsRegistry) {
        this.successes = metricsRegistry.createCounter(this.getActionName() + "_successes", "Rollover Action Successes", "count");
        this.failures = metricsRegistry.createCounter(this.getActionName() + "_failures", "Rollover Action Failures", "count");
        this.cumulativeLatency = metricsRegistry.createCounter(this.getActionName() + "_cumulative_latency", "Cumulative Latency of Rollover Actions", "milliseconds");
    }

    @Override
    public void emitMetrics(StepContext context, IndexManagementActionsMetrics indexManagementActionsMetrics, StepMetaData stepMetaData) {
        Step.StepStatus stepStatus;
        RolloverActionMetrics rolloverActionMetrics = (RolloverActionMetrics)indexManagementActionsMetrics.getActionMetrics("rollover");
        Step.StepStatus stepStatus2 = stepStatus = stepMetaData != null ? stepMetaData.getStepStatus() : null;
        if (stepStatus == Step.StepStatus.COMPLETED) {
            rolloverActionMetrics.successes.add(1.0, rolloverActionMetrics.createTags(context));
        }
        if (stepStatus == Step.StepStatus.FAILED) {
            rolloverActionMetrics.failures.add(1.0, rolloverActionMetrics.createTags(context));
        }
        long endTime = System.currentTimeMillis();
        Long startTime = context.getMetadata().getStepMetaData() != null ? Long.valueOf(context.getMetadata().getStepMetaData().getStartTime()) : null;
        long latency = endTime - (startTime != null ? startTime : endTime);
        rolloverActionMetrics.cumulativeLatency.add((double)latency, rolloverActionMetrics.createTags(context));
    }

    private static class Holder {
        private static final RolloverActionMetrics INSTANCE = new RolloverActionMetrics();

        private Holder() {
        }
    }
}

