/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.metrics.actionmetrics;

import io.skylite.core.telemetry.metrics.Counter;
import io.skylite.core.telemetry.metrics.MetricsRegistry;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.metrics.ActionMetrics;
import io.skylite.indexmanagement.metrics.IndexManagementActionsMetrics;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;

public class SetIndexPriorityActionMetrics
extends ActionMetrics {
    private Counter successes;
    private Counter failures;
    private Counter cumulativeLatency;

    private SetIndexPriorityActionMetrics() {
    }

    public static SetIndexPriorityActionMetrics getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public String getActionName() {
        return "set_index_priority";
    }

    public void initializeCounters(MetricsRegistry metricsRegistry) {
        this.successes = metricsRegistry.createCounter(this.getActionName() + "_successes", "Set Index Priority Action Successes", "count");
        this.failures = metricsRegistry.createCounter(this.getActionName() + "_failures", "Set Index Priority Action Failures", "count");
        this.cumulativeLatency = metricsRegistry.createCounter(this.getActionName() + "_cumulative_latency", "Cumulative Latency of Set Index Priority Actions", "milliseconds");
    }

    @Override
    public void emitMetrics(StepContext context, IndexManagementActionsMetrics indexManagementActionsMetrics, StepMetaData stepMetaData) {
        Step.StepStatus stepStatus;
        SetIndexPriorityActionMetrics setIndexPriorityActionMetrics = (SetIndexPriorityActionMetrics)indexManagementActionsMetrics.getActionMetrics("set_index_priority");
        Step.StepStatus stepStatus2 = stepStatus = stepMetaData != null ? stepMetaData.getStepStatus() : null;
        if (stepStatus == Step.StepStatus.COMPLETED) {
            setIndexPriorityActionMetrics.successes.add(1.0, setIndexPriorityActionMetrics.createTags(context));
        }
        if (stepStatus == Step.StepStatus.FAILED) {
            setIndexPriorityActionMetrics.failures.add(1.0, setIndexPriorityActionMetrics.createTags(context));
        }
        long endTime = System.currentTimeMillis();
        Long startTime = context.getMetadata().getStepMetaData() != null ? Long.valueOf(context.getMetadata().getStepMetaData().getStartTime()) : null;
        long latency = endTime - (startTime != null ? startTime : endTime);
        setIndexPriorityActionMetrics.cumulativeLatency.add((double)latency, setIndexPriorityActionMetrics.createTags(context));
    }

    private static class Holder {
        private static final SetIndexPriorityActionMetrics INSTANCE = new SetIndexPriorityActionMetrics();

        private Holder() {
        }
    }
}

