/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.metrics.actionmetrics;

import io.skylite.core.telemetry.metrics.Counter;
import io.skylite.core.telemetry.metrics.MetricsRegistry;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.metrics.ActionMetrics;
import io.skylite.indexmanagement.metrics.IndexManagementActionsMetrics;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;

public class SetReadOnlyActionMetrics
extends ActionMetrics {
    private Counter successes;
    private Counter failures;
    private Counter cumulativeLatency;

    public Counter getSuccesses() {
        return this.successes;
    }

    public Counter getFailures() {
        return this.failures;
    }

    private SetReadOnlyActionMetrics() {
    }

    public static SetReadOnlyActionMetrics getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public String getActionName() {
        return "set_read_only";
    }

    public void initializeCounters(MetricsRegistry metricsRegistry) {
        this.successes = metricsRegistry.createCounter(this.getActionName() + "_successes", "Set Read Only Action Successes", "count");
        this.failures = metricsRegistry.createCounter(this.getActionName() + "_failures", "Set Read Only Action Failures", "count");
        this.cumulativeLatency = metricsRegistry.createCounter(this.getActionName() + "_cumulative_latency", "Cumulative Latency of Set Read Only Actions", "milliseconds");
    }

    @Override
    public void emitMetrics(StepContext context, IndexManagementActionsMetrics indexManagementActionsMetrics, StepMetaData stepMetaData) {
        Step.StepStatus stepStatus;
        SetReadOnlyActionMetrics setReadOnlyActionMetrics = (SetReadOnlyActionMetrics)indexManagementActionsMetrics.getActionMetrics("set_read_only");
        Step.StepStatus stepStatus2 = stepStatus = stepMetaData != null ? stepMetaData.getStepStatus() : null;
        if (stepStatus == Step.StepStatus.COMPLETED) {
            setReadOnlyActionMetrics.successes.add(1.0, setReadOnlyActionMetrics.createTags(context));
        }
        if (stepStatus == Step.StepStatus.FAILED) {
            setReadOnlyActionMetrics.failures.add(1.0, setReadOnlyActionMetrics.createTags(context));
        }
        long endTime = System.currentTimeMillis();
        Long startTime = context.getMetadata().getStepMetaData() != null ? Long.valueOf(context.getMetadata().getStepMetaData().getStartTime()) : null;
        long latency = endTime - (startTime != null ? startTime : endTime);
        setReadOnlyActionMetrics.cumulativeLatency.add((double)latency, setReadOnlyActionMetrics.createTags(context));
    }

    private static class Holder {
        private static final SetReadOnlyActionMetrics INSTANCE = new SetReadOnlyActionMetrics();

        private Holder() {
        }
    }
}

