/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.metrics.actionmetrics;

import io.skylite.core.telemetry.metrics.Counter;
import io.skylite.core.telemetry.metrics.MetricsRegistry;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.metrics.ActionMetrics;
import io.skylite.indexmanagement.metrics.IndexManagementActionsMetrics;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;

public class ShrinkActionMetrics
extends ActionMetrics {
    private Counter successes;
    private Counter failures;
    private Counter cumulativeLatency;

    private ShrinkActionMetrics() {
    }

    public static ShrinkActionMetrics getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public String getActionName() {
        return "shrink";
    }

    public void initializeCounters(MetricsRegistry metricsRegistry) {
        this.successes = metricsRegistry.createCounter(this.getActionName() + "_successes", "Shrink Action Successes", "count");
        this.failures = metricsRegistry.createCounter(this.getActionName() + "_failures", "Shrink Action Failures", "count");
        this.cumulativeLatency = metricsRegistry.createCounter(this.getActionName() + "_cumulative_latency", "Cumulative Latency of Shrink Actions", "milliseconds");
    }

    @Override
    public void emitMetrics(StepContext context, IndexManagementActionsMetrics indexManagementActionsMetrics, StepMetaData stepMetaData) {
        Step.StepStatus stepStatus;
        ShrinkActionMetrics shrinkActionMetrics = (ShrinkActionMetrics)indexManagementActionsMetrics.getActionMetrics("shrink");
        Step.StepStatus stepStatus2 = stepStatus = stepMetaData != null ? stepMetaData.getStepStatus() : null;
        if (stepStatus == Step.StepStatus.COMPLETED) {
            shrinkActionMetrics.successes.add(1.0, shrinkActionMetrics.createTags(context));
        }
        if (stepStatus == Step.StepStatus.FAILED) {
            shrinkActionMetrics.failures.add(1.0, shrinkActionMetrics.createTags(context));
        }
        long endTime = System.currentTimeMillis();
        Long startTime = context.getMetadata().getStepMetaData() != null ? Long.valueOf(context.getMetadata().getStepMetaData().getStartTime()) : null;
        long latency = endTime - (startTime != null ? startTime : endTime);
        shrinkActionMetrics.cumulativeLatency.add((double)latency, shrinkActionMetrics.createTags(context));
    }

    private static class Holder {
        private static final ShrinkActionMetrics INSTANCE = new ShrinkActionMetrics();

        private Holder() {
        }
    }
}

