/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.metrics.actionmetrics;

import io.skylite.core.telemetry.metrics.Counter;
import io.skylite.core.telemetry.metrics.MetricsRegistry;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.metrics.ActionMetrics;
import io.skylite.indexmanagement.metrics.IndexManagementActionsMetrics;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;

public class SnapshotActionMetrics
extends ActionMetrics {
    private Counter successes;
    private Counter failures;
    private Counter cumulativeLatency;

    public Counter getSuccesses() {
        return this.successes;
    }

    public Counter getFailures() {
        return this.failures;
    }

    private SnapshotActionMetrics() {
    }

    public static SnapshotActionMetrics getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public String getActionName() {
        return "snapshot";
    }

    public void initializeCounters(MetricsRegistry metricsRegistry) {
        this.successes = metricsRegistry.createCounter(this.getActionName() + "_successes", "Snapshot Action Successes", "count");
        this.failures = metricsRegistry.createCounter(this.getActionName() + "_failures", "Snapshot Action Failures", "count");
        this.cumulativeLatency = metricsRegistry.createCounter(this.getActionName() + "_cumulative_latency", "Cumulative Latency of Snapshot Actions", "milliseconds");
    }

    @Override
    public void emitMetrics(StepContext context, IndexManagementActionsMetrics indexManagementActionsMetrics, StepMetaData stepMetaData) {
        Step.StepStatus stepStatus;
        SnapshotActionMetrics snapshotActionMetrics = (SnapshotActionMetrics)indexManagementActionsMetrics.getActionMetrics("snapshot");
        Step.StepStatus stepStatus2 = stepStatus = stepMetaData != null ? stepMetaData.getStepStatus() : null;
        if (stepStatus == Step.StepStatus.COMPLETED) {
            snapshotActionMetrics.successes.add(1.0, snapshotActionMetrics.createTags(context));
        }
        if (stepStatus == Step.StepStatus.FAILED) {
            snapshotActionMetrics.failures.add(1.0, snapshotActionMetrics.createTags(context));
        }
        long endTime = System.currentTimeMillis();
        Long startTime = context.getMetadata().getStepMetaData() != null ? Long.valueOf(context.getMetadata().getStepMetaData().getStartTime()) : null;
        long latency = endTime - (startTime != null ? startTime : endTime);
        snapshotActionMetrics.cumulativeLatency.add((double)latency, snapshotActionMetrics.createTags(context));
    }

    private static class Holder {
        private static final SnapshotActionMetrics INSTANCE = new SnapshotActionMetrics();

        private Holder() {
        }
    }
}

