/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.metrics.actionmetrics;

import io.skylite.core.telemetry.metrics.Counter;
import io.skylite.core.telemetry.metrics.MetricsRegistry;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.metrics.ActionMetrics;
import io.skylite.indexmanagement.metrics.IndexManagementActionsMetrics;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;

public class TransitionActionMetrics
extends ActionMetrics {
    private Counter successes;
    private Counter failures;
    private Counter cumulativeLatency;

    public Counter getSuccesses() {
        return this.successes;
    }

    public Counter getFailures() {
        return this.failures;
    }

    private TransitionActionMetrics() {
    }

    public static TransitionActionMetrics getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public String getActionName() {
        return "transition";
    }

    public void initializeCounters(MetricsRegistry metricsRegistry) {
        this.successes = metricsRegistry.createCounter(this.getActionName() + "_successes", "Transition Action Successes", "count");
        this.failures = metricsRegistry.createCounter(this.getActionName() + "_failures", "Transition Action Failures", "count");
        this.cumulativeLatency = metricsRegistry.createCounter(this.getActionName() + "_cumulative_latency", "Cumulative Latency of Transition Actions", "milliseconds");
    }

    @Override
    public void emitMetrics(StepContext context, IndexManagementActionsMetrics indexManagementActionsMetrics, StepMetaData stepMetaData) {
        Step.StepStatus stepStatus;
        TransitionActionMetrics transitionActionMetrics = (TransitionActionMetrics)indexManagementActionsMetrics.getActionMetrics("transition");
        Step.StepStatus stepStatus2 = stepStatus = stepMetaData != null ? stepMetaData.getStepStatus() : null;
        if (stepStatus == Step.StepStatus.COMPLETED) {
            transitionActionMetrics.successes.add(1.0, transitionActionMetrics.createTags(context));
        }
        if (stepStatus == Step.StepStatus.FAILED) {
            transitionActionMetrics.failures.add(1.0, transitionActionMetrics.createTags(context));
        }
        long endTime = System.currentTimeMillis();
        Long startTime = context.getMetadata().getStepMetaData() != null ? Long.valueOf(context.getMetadata().getStepMetaData().getStartTime()) : null;
        long latency = endTime - (startTime != null ? startTime : endTime);
        transitionActionMetrics.cumulativeLatency.add((double)latency, transitionActionMetrics.createTags(context));
    }

    private static class Holder {
        private static final TransitionActionMetrics INSTANCE = new TransitionActionMetrics();

        private Holder() {
        }
    }
}

