/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.model;

import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.indexmanagement.model.ActionProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;

public class ActionMetaData
implements Writeable,
ToXContentFragment {
    public static final String ACTION = "action";
    public static final String INDEX = "index";
    public static final String FAILED = "failed";
    public static final String CONSUMED_RETRIES = "consumed_retries";
    public static final String LAST_RETRY_TIME = "last_retry_time";
    private final String name;
    private final Long startTime;
    private final int index;
    private final boolean failed;
    private final int consumedRetries;
    private final Long lastRetryTime;
    private final ActionProperties actionProperties;

    public ActionMetaData(String name, Long startTime, int index, boolean failed, int consumedRetries, Long lastRetryTime, ActionProperties actionProperties) {
        this.name = name;
        this.startTime = startTime;
        this.index = index;
        this.failed = failed;
        this.consumedRetries = consumedRetries;
        this.lastRetryTime = lastRetryTime;
        this.actionProperties = actionProperties;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeOptionalLong(this.startTime);
        out.writeInt(this.index);
        out.writeBoolean(this.failed);
        out.writeInt(this.consumedRetries);
        out.writeOptionalLong(this.lastRetryTime);
        out.writeOptionalWriteable((Writeable)this.actionProperties);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("name", this.name).field("start_time", this.startTime).field(INDEX, this.index).field(FAILED, this.failed).field(CONSUMED_RETRIES, this.consumedRetries).field(LAST_RETRY_TIME, this.lastRetryTime);
        if (this.actionProperties != null) {
            builder.startObject("action_properties");
            this.actionProperties.toXContent(builder, params);
            builder.endObject();
        }
        return builder;
    }

    public String getMapValueString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    public String getName() {
        return this.name;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean getFailed() {
        return this.failed;
    }

    public int getConsumedRetries() {
        return this.consumedRetries;
    }

    public Long getLastRetryTime() {
        return this.lastRetryTime;
    }

    public ActionProperties getActionProperties() {
        return this.actionProperties;
    }

    public ActionMetaData copy(Long newStartTime) {
        return new ActionMetaData(this.name, newStartTime, this.index, this.failed, this.consumedRetries, this.lastRetryTime, this.actionProperties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionMetaData that = (ActionMetaData)o;
        return this.index == that.index && this.failed == that.failed && this.consumedRetries == that.consumedRetries && Objects.equals(this.name, that.name) && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.lastRetryTime, that.lastRetryTime) && Objects.equals(this.actionProperties, that.actionProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.startTime, this.index, this.failed, this.consumedRetries, this.lastRetryTime, this.actionProperties);
    }

    public String toString() {
        return "ActionMetaData{name='" + this.name + "', startTime=" + this.startTime + ", index=" + this.index + ", failed=" + this.failed + ", consumedRetries=" + this.consumedRetries + ", lastRetryTime=" + this.lastRetryTime + ", actionProperties=" + String.valueOf(this.actionProperties) + "}";
    }

    public static ActionMetaData fromStreamInput(StreamInput si) throws IOException {
        String name = si.readString();
        Long startTime = si.readOptionalLong();
        Integer index = si.readInt();
        Boolean failed = si.readBoolean();
        Integer consumedRetries = si.readInt();
        Long lastRetryTime = si.readOptionalLong();
        ActionProperties actionProperties = (ActionProperties)si.readOptionalWriteable(ActionProperties::fromStreamInput);
        return new ActionMetaData(Objects.requireNonNull(name, "name is null"), startTime, Objects.requireNonNull(index, "index is null"), Objects.requireNonNull(failed, "failed is null"), Objects.requireNonNull(consumedRetries, "consumed_retries is null"), lastRetryTime, actionProperties);
    }

    public static ActionMetaData fromManagedIndexMetaDataMap(Map<String, String> map) throws IOException {
        String actionJsonString = map.get(ACTION);
        if (actionJsonString != null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(actionJsonString.getBytes(StandardCharsets.UTF_8));
            XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)inputStream);
            parser.nextToken();
            return ActionMetaData.parse(parser);
        }
        return null;
    }

    public static ActionMetaData parse(XContentParser xcp) throws IOException {
        String name = null;
        Long startTime = null;
        Integer index = null;
        Boolean failed = null;
        Integer consumedRetries = null;
        Long lastRetryTime = null;
        ActionProperties actionProperties = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "name": {
                    name = xcp.text();
                    break;
                }
                case "start_time": {
                    startTime = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Long.valueOf(xcp.longValue());
                    break;
                }
                case "index": {
                    index = xcp.intValue();
                    break;
                }
                case "failed": {
                    failed = xcp.booleanValue();
                    break;
                }
                case "consumed_retries": {
                    consumedRetries = xcp.intValue();
                    break;
                }
                case "last_retry_time": {
                    lastRetryTime = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Long.valueOf(xcp.longValue());
                    break;
                }
                case "action_properties": {
                    actionProperties = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : ActionProperties.parse(xcp);
                }
            }
        }
        return new ActionMetaData(Objects.requireNonNull(name, "name is null"), startTime, (Integer)Objects.requireNonNull(index, "index is null"), (Boolean)Objects.requireNonNull(failed, "failed is null"), Objects.requireNonNull(consumedRetries, "consumed_retries is null"), lastRetryTime, actionProperties);
    }

    public static class Builder {
        private String name;
        private Long startTime;
        private int index;
        private boolean failed;
        private int consumedRetries;
        private Long lastRetryTime;
        private ActionProperties actionProperties;

        public Builder() {
        }

        public Builder(ActionMetaData metadata) {
            this.name = metadata.name;
            this.startTime = metadata.startTime;
            this.index = metadata.index;
            this.failed = metadata.failed;
            this.consumedRetries = metadata.consumedRetries;
            this.lastRetryTime = metadata.lastRetryTime;
            this.actionProperties = metadata.actionProperties;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder index(int index) {
            this.index = index;
            return this;
        }

        public Builder failed(boolean failed) {
            this.failed = failed;
            return this;
        }

        public Builder consumedRetries(int consumedRetries) {
            this.consumedRetries = consumedRetries;
            return this;
        }

        public Builder lastRetryTime(Long lastRetryTime) {
            this.lastRetryTime = lastRetryTime;
            return this;
        }

        public Builder actionProperties(ActionProperties actionProperties) {
            this.actionProperties = actionProperties;
            return this;
        }

        public ActionMetaData build() {
            return new ActionMetaData(this.name, this.startTime, this.index, this.failed, this.consumedRetries, this.lastRetryTime, this.actionProperties);
        }
    }
}

