/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.model;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.indexmanagement.XContentUtils;
import io.skylite.indexmanagement.model.ShrinkActionProperties;
import io.skylite.indexmanagement.model.TransformActionProperties;
import java.io.IOException;
import java.util.Objects;

public class ActionProperties
implements Writeable,
ToXContentFragment {
    public static final String ACTION_PROPERTIES = "action_properties";
    private final Integer maxNumSegments;
    private final String snapshotName;
    private final String rollupId;
    private final Boolean hasRollupFailed;
    private final ShrinkActionProperties shrinkActionProperties;
    private final TransformActionProperties transformActionProperties;

    public ActionProperties(Integer maxNumSegments, String snapshotName, String rollupId, Boolean hasRollupFailed, ShrinkActionProperties shrinkActionProperties, TransformActionProperties transformActionProperties) {
        this.maxNumSegments = maxNumSegments;
        this.snapshotName = snapshotName;
        this.rollupId = rollupId;
        this.hasRollupFailed = hasRollupFailed;
        this.shrinkActionProperties = shrinkActionProperties;
        this.transformActionProperties = transformActionProperties;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInt(this.maxNumSegments);
        out.writeOptionalString(this.snapshotName);
        out.writeOptionalString(this.rollupId);
        out.writeOptionalBoolean(this.hasRollupFailed);
        out.writeOptionalWriteable((Writeable)this.shrinkActionProperties);
        out.writeOptionalWriteable((Writeable)this.transformActionProperties);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.maxNumSegments != null) {
            builder.field(Properties.MAX_NUM_SEGMENTS.getKey(), this.maxNumSegments);
        }
        if (this.snapshotName != null) {
            builder.field(Properties.SNAPSHOT_NAME.getKey(), this.snapshotName);
        }
        if (this.rollupId != null) {
            builder.field(Properties.ROLLUP_ID.getKey(), this.rollupId);
        }
        if (this.hasRollupFailed != null) {
            builder.field(Properties.HAS_ROLLUP_FAILED.getKey(), this.hasRollupFailed);
        }
        if (this.shrinkActionProperties != null) {
            XContentUtils.addObject(builder, "shrink_action_properties", this.shrinkActionProperties, params);
        }
        if (this.transformActionProperties != null) {
            XContentUtils.addObject(builder, "transform_action_properties", this.transformActionProperties, params);
        }
        return builder;
    }

    public Integer getMaxNumSegments() {
        return this.maxNumSegments;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public String getRollupId() {
        return this.rollupId;
    }

    public Boolean getHasRollupFailed() {
        return this.hasRollupFailed;
    }

    public ShrinkActionProperties getShrinkActionProperties() {
        return this.shrinkActionProperties;
    }

    public TransformActionProperties getTransformActionProperties() {
        return this.transformActionProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionProperties that = (ActionProperties)o;
        return Objects.equals(this.maxNumSegments, that.maxNumSegments) && Objects.equals(this.snapshotName, that.snapshotName) && Objects.equals(this.rollupId, that.rollupId) && Objects.equals(this.hasRollupFailed, that.hasRollupFailed) && Objects.equals(this.shrinkActionProperties, that.shrinkActionProperties) && Objects.equals(this.transformActionProperties, that.transformActionProperties);
    }

    public int hashCode() {
        return Objects.hash(this.maxNumSegments, this.snapshotName, this.rollupId, this.hasRollupFailed, this.shrinkActionProperties, this.transformActionProperties);
    }

    public String toString() {
        return "ActionProperties{maxNumSegments=" + this.maxNumSegments + ", snapshotName='" + this.snapshotName + "', rollupId='" + this.rollupId + "', hasRollupFailed=" + this.hasRollupFailed + ", shrinkActionProperties=" + String.valueOf(this.shrinkActionProperties) + ", transformActionProperties=" + String.valueOf(this.transformActionProperties) + "}";
    }

    public static ActionProperties fromStreamInput(StreamInput si) throws IOException {
        Integer maxNumSegments = si.readOptionalInt();
        String snapshotName = si.readOptionalString();
        String rollupId = si.readOptionalString();
        Boolean hasRollupFailed = si.readOptionalBoolean();
        ShrinkActionProperties shrinkActionProperties = (ShrinkActionProperties)si.readOptionalWriteable(ShrinkActionProperties::fromStreamInput);
        TransformActionProperties transformActionProperties = (TransformActionProperties)si.readOptionalWriteable(TransformActionProperties::fromStreamInput);
        return new ActionProperties(maxNumSegments, snapshotName, rollupId, hasRollupFailed, shrinkActionProperties, transformActionProperties);
    }

    public static ActionProperties parse(XContentParser xcp) throws IOException {
        Integer maxNumSegments = null;
        String snapshotName = null;
        String rollupId = null;
        Boolean hasRollupFailed = null;
        ShrinkActionProperties shrinkActionProperties = null;
        TransformActionProperties transformActionProperties = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "max_num_segments": {
                    maxNumSegments = xcp.intValue();
                    break;
                }
                case "snapshot_name": {
                    snapshotName = xcp.text();
                    break;
                }
                case "rollup_id": {
                    rollupId = xcp.text();
                    break;
                }
                case "has_rollup_failed": {
                    hasRollupFailed = xcp.booleanValue();
                    break;
                }
                case "shrink_action_properties": {
                    shrinkActionProperties = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : ShrinkActionProperties.parse(xcp);
                    break;
                }
                case "transform_action_properties": {
                    transformActionProperties = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : TransformActionProperties.parse(xcp);
                }
            }
        }
        return new ActionProperties(maxNumSegments, snapshotName, rollupId, hasRollupFailed, shrinkActionProperties, transformActionProperties);
    }

    public static enum Properties {
        MAX_NUM_SEGMENTS("max_num_segments"),
        SNAPSHOT_NAME("snapshot_name"),
        ROLLUP_ID("rollup_id"),
        HAS_ROLLUP_FAILED("has_rollup_failed");

        private final String key;

        private Properties(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static class Builder {
        private Integer maxNumSegments = null;
        private String snapshotName = null;
        private String rollupId = null;
        private Boolean hasRollupFailed = null;
        private ShrinkActionProperties shrinkActionProperties = null;
        private TransformActionProperties transformActionProperties = null;

        public Builder maxNumSegments(int maxNumSegments) {
            this.maxNumSegments = maxNumSegments;
            return this;
        }

        public Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public Builder rollupId(String rollupId) {
            this.rollupId = rollupId;
            return this;
        }

        public Builder hasRollupFailed(Boolean hasRollupFailed) {
            this.hasRollupFailed = hasRollupFailed;
            return this;
        }

        public Builder shrinkActionProperties(ShrinkActionProperties shrinkActionProperties) {
            this.shrinkActionProperties = shrinkActionProperties;
            return this;
        }

        public Builder transformActionProperties(TransformActionProperties transformActionProperties) {
            this.transformActionProperties = transformActionProperties;
            return this;
        }

        public ActionProperties build() {
            return new ActionProperties(this.maxNumSegments, this.snapshotName, this.rollupId, this.hasRollupFailed, this.shrinkActionProperties, this.transformActionProperties);
        }
    }
}

