/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.model;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.indexmanagement.model.ActionMetaData;
import java.io.IOException;
import java.time.Instant;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActionRetry
implements ToXContentFragment,
Writeable {
    public static final String RETRY_FIELD = "retry";
    public static final String COUNT_FIELD = "count";
    public static final String BACKOFF_FIELD = "backoff";
    public static final String DELAY_FIELD = "delay";
    private final long count;
    private final Backoff backoff;
    private final TimeValue delay;

    public ActionRetry(long count, Backoff backoff, TimeValue delay) {
        if (count < 0L) {
            throw new IllegalArgumentException("Count for ActionRetry must be a non-negative number");
        }
        this.count = count;
        this.backoff = backoff;
        this.delay = delay;
    }

    public ActionRetry(long count) {
        this(count, Backoff.EXPONENTIAL, TimeValue.timeValueMinutes((long)1L));
    }

    public ActionRetry(StreamInput sin) throws IOException {
        this(sin.readLong(), (Backoff)sin.readEnum(Backoff.class), sin.readTimeValue());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.count);
        out.writeEnum((Enum)this.backoff);
        out.writeTimeValue(this.delay);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(RETRY_FIELD).field(COUNT_FIELD, this.count).field(BACKOFF_FIELD, (Object)this.backoff).field(DELAY_FIELD, this.delay.getStringRep()).endObject();
        return builder;
    }

    public long getCount() {
        return this.count;
    }

    public Backoff getBackoff() {
        return this.backoff;
    }

    public TimeValue getDelay() {
        return this.delay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionRetry that = (ActionRetry)o;
        return this.count == that.count && this.backoff == that.backoff && Objects.equals(this.delay, that.delay);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.count, this.backoff, this.delay});
    }

    public String toString() {
        return "ActionRetry{count=" + this.count + ", backoff=" + String.valueOf((Object)this.backoff) + ", delay=" + String.valueOf(this.delay) + "}";
    }

    public static ActionRetry parse(XContentParser xcp) throws IOException {
        Long count = null;
        Backoff backoff = Backoff.EXPONENTIAL;
        TimeValue delay = TimeValue.timeValueMinutes((long)1L);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "count": {
                    count = xcp.longValue();
                    break;
                }
                case "backoff": {
                    backoff = Backoff.valueOf(xcp.text().toUpperCase(Locale.ROOT));
                    break;
                }
                case "delay": {
                    delay = TimeValue.parseTimeValue((String)xcp.text(), (String)DELAY_FIELD);
                }
            }
        }
        return new ActionRetry((Long)Objects.requireNonNull(count, "ActionRetry count is null"), backoff, delay);
    }

    public static enum Backoff {
        EXPONENTIAL("exponential"){

            @Override
            public long getNextRetryTime(int consumedRetries, TimeValue timeValue) {
                return (long)Math.pow(2.0, consumedRetries - 1) * timeValue.millis();
            }
        }
        ,
        CONSTANT("constant"){

            @Override
            public long getNextRetryTime(int consumedRetries, TimeValue timeValue) {
                return timeValue.millis();
            }
        }
        ,
        LINEAR("linear"){

            @Override
            public long getNextRetryTime(int consumedRetries, TimeValue timeValue) {
                return (long)consumedRetries * timeValue.millis();
            }
        };

        private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        private final String type;

        private Backoff(String type) {
            this.type = type;
        }

        public abstract long getNextRetryTime(int var1, TimeValue var2);

        public String toString() {
            return this.type;
        }

        public BackoffResult shouldBackoff(ActionMetaData actionMetaData, ActionRetry actionRetry) {
            Long lastRetryTime;
            if (actionMetaData == null || actionRetry == null) {
                this.logger.debug("There is no actionMetaData and ActionRetry we don't need to backoff");
                return new BackoffResult(false, null);
            }
            if (actionMetaData.getConsumedRetries() > 0 && (lastRetryTime = actionMetaData.getLastRetryTime()) != null) {
                long remainingTime = this.getNextRetryTime(actionMetaData.getConsumedRetries(), actionRetry.delay) - (Instant.now().toEpochMilli() - lastRetryTime);
                return new BackoffResult(remainingTime > 0L, remainingTime);
            }
            return new BackoffResult(false, null);
        }

        public static class BackoffResult {
            private final boolean shouldBackoff;
            private final Long remainingTime;

            public BackoffResult(boolean shouldBackoff, Long remainingTime) {
                this.shouldBackoff = shouldBackoff;
                this.remainingTime = remainingTime;
            }

            public boolean shouldBackoff() {
                return this.shouldBackoff;
            }

            public Long getRemainingTime() {
                return this.remainingTime;
            }
        }
    }
}

