/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.model;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.indexmanagement.XContentUtils;
import io.skylite.indexmanagement.model.ActionMetaData;
import io.skylite.indexmanagement.model.PolicyRetryInfoMetaData;
import io.skylite.indexmanagement.model.StateMetaData;
import io.skylite.indexmanagement.model.StepMetaData;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ManagedIndexMetaData
implements Writeable,
ToXContentFragment {
    public static final String NO_ID = "";
    public static final String MANAGED_INDEX_METADATA_TYPE = "managed_index_metadata";
    public static final String NAME = "name";
    public static final String START_TIME = "start_time";
    public static final String INDEX = "index";
    public static final String INDEX_UUID = "index_uuid";
    public static final String POLICY_ID = "policy_id";
    public static final String POLICY_SEQ_NO = "policy_seq_no";
    public static final String POLICY_PRIMARY_TERM = "policy_primary_term";
    public static final String POLICY_COMPLETED = "policy_completed";
    public static final String ROLLED_OVER = "rolled_over";
    public static final String ROLLED_OVER_INDEX_NAME = "rolled_over_index_name";
    public static final String INDEX_CREATION_DATE = "index_creation_date";
    public static final String TRANSITION_TO = "transition_to";
    public static final String INFO = "info";
    public static final String ENABLED = "enabled";
    private final String index;
    private final String indexUuid;
    private final String policyID;
    private final Long policySeqNo;
    private final Long policyPrimaryTerm;
    private final Boolean policyCompleted;
    private final Boolean rolledOver;
    private final Long indexCreationDate;
    private final String transitionTo;
    private final StateMetaData stateMetaData;
    private final ActionMetaData actionMetaData;
    private final StepMetaData stepMetaData;
    private final PolicyRetryInfoMetaData policyRetryInfo;
    private final Map<String, Object> info;
    private final String id;
    private final long seqNo;
    private final long primaryTerm;
    private final String rolledOverIndexName;

    public ManagedIndexMetaData(String index, String indexUuid, String policyID, Long policySeqNo, Long policyPrimaryTerm, Boolean policyCompleted, Boolean rolledOver, Long indexCreationDate, String transitionTo, StateMetaData stateMetaData, ActionMetaData actionMetaData, StepMetaData stepMetaData, PolicyRetryInfoMetaData policyRetryInfo, Map<String, Object> info, String id, long seqNo, long primaryTerm, String rolledOverIndexName) {
        this.index = index;
        this.indexUuid = indexUuid;
        this.policyID = policyID;
        this.policySeqNo = policySeqNo;
        this.policyPrimaryTerm = policyPrimaryTerm;
        this.policyCompleted = policyCompleted;
        this.rolledOver = rolledOver;
        this.indexCreationDate = indexCreationDate;
        this.transitionTo = transitionTo;
        this.stateMetaData = stateMetaData;
        this.actionMetaData = actionMetaData;
        this.stepMetaData = stepMetaData;
        this.policyRetryInfo = policyRetryInfo;
        this.info = info;
        this.id = id;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.rolledOverIndexName = rolledOverIndexName;
    }

    public ManagedIndexMetaData(String index, String indexUuid, String policyID, Long policySeqNo, Long policyPrimaryTerm, Boolean policyCompleted, Boolean rolledOver, Long indexCreationDate, String transitionTo, StateMetaData stateMetaData, ActionMetaData actionMetaData, StepMetaData stepMetaData, PolicyRetryInfoMetaData policyRetryInfo, Map<String, Object> info) {
        this(index, indexUuid, policyID, policySeqNo, policyPrimaryTerm, policyCompleted, rolledOver, indexCreationDate, transitionTo, stateMetaData, actionMetaData, stepMetaData, policyRetryInfo, info, NO_ID, -2L, 0L, null);
    }

    public Map<String, String> toMap() {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put(INDEX, this.index);
        resultMap.put(INDEX_UUID, this.indexUuid);
        resultMap.put(POLICY_ID, this.policyID);
        if (this.policySeqNo != null) {
            resultMap.put(POLICY_SEQ_NO, this.policySeqNo.toString());
        }
        if (this.policyPrimaryTerm != null) {
            resultMap.put(POLICY_PRIMARY_TERM, this.policyPrimaryTerm.toString());
        }
        if (this.policyCompleted != null) {
            resultMap.put(POLICY_COMPLETED, this.policyCompleted.toString());
        }
        if (this.rolledOver != null) {
            resultMap.put(ROLLED_OVER, this.rolledOver.toString());
        }
        if (this.rolledOverIndexName != null) {
            resultMap.put(ROLLED_OVER_INDEX_NAME, this.rolledOverIndexName);
        }
        if (this.indexCreationDate != null) {
            resultMap.put(INDEX_CREATION_DATE, this.indexCreationDate.toString());
        }
        if (this.transitionTo != null) {
            resultMap.put(TRANSITION_TO, this.transitionTo);
        }
        if (this.stateMetaData != null) {
            resultMap.put("state", this.stateMetaData.getMapValueString());
        }
        if (this.actionMetaData != null) {
            resultMap.put("action", this.actionMetaData.getMapValueString());
        }
        if (this.stepMetaData != null) {
            resultMap.put("step", this.stepMetaData.getMapValueString());
        }
        if (this.policyRetryInfo != null) {
            resultMap.put("retry_info", this.policyRetryInfo.getMapValueString());
        }
        if (this.info != null) {
            try {
                assert (MediaTypeRegistry.JSON != null);
                try (XContentBuilder xcb = MediaTypeRegistry.JSON.contentBuilder();){
                    resultMap.put(INFO, xcb.map(this.info).toString());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to serialize info map", e);
            }
        }
        return resultMap;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, boolean forIndex) throws IOException {
        if (!forIndex) {
            return this.toXContent(builder, params);
        }
        builder.startObject().startObject(MANAGED_INDEX_METADATA_TYPE).field(INDEX, this.index).field(INDEX_UUID, this.indexUuid).field(POLICY_ID, this.policyID).field(POLICY_SEQ_NO, this.policySeqNo).field(POLICY_PRIMARY_TERM, this.policyPrimaryTerm).field(POLICY_COMPLETED, this.policyCompleted).field(ROLLED_OVER, this.rolledOver).field(ROLLED_OVER_INDEX_NAME, this.rolledOverIndexName).field(INDEX_CREATION_DATE, this.indexCreationDate).field(TRANSITION_TO, this.transitionTo);
        XContentUtils.addObject(builder, "state", this.stateMetaData, params, true);
        XContentUtils.addObject(builder, "action", this.actionMetaData, params, true);
        XContentUtils.addObject(builder, "step", this.stepMetaData, params, true);
        XContentUtils.addObject(builder, "retry_info", this.policyRetryInfo, params, true);
        builder.field(INFO, this.info).endObject().endObject();
        return builder;
    }

    public boolean isFailed() {
        if (this.policyRetryInfo != null && this.policyRetryInfo.getFailed()) {
            return true;
        }
        return this.actionMetaData != null && this.actionMetaData.getFailed();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean transitionToExists;
        builder.field(INDEX, this.index).field(INDEX_UUID, this.indexUuid).field(POLICY_ID, this.policyID);
        if (this.policySeqNo != null) {
            builder.field(POLICY_SEQ_NO, this.policySeqNo);
        }
        if (this.policyPrimaryTerm != null) {
            builder.field(POLICY_PRIMARY_TERM, this.policyPrimaryTerm);
        }
        if (Boolean.TRUE.equals(this.rolledOver) || this.actionMetaData != null && "rollover".equals(this.actionMetaData.getName())) {
            builder.field(ROLLED_OVER, this.rolledOver);
            if (this.rolledOverIndexName != null) {
                builder.field(ROLLED_OVER_INDEX_NAME, this.rolledOverIndexName);
            }
        }
        if (this.indexCreationDate != null) {
            builder.field(INDEX_CREATION_DATE, this.indexCreationDate);
        }
        if (Boolean.TRUE.equals(this.policyCompleted)) {
            builder.field(POLICY_COMPLETED, this.policyCompleted);
            return builder;
        }
        boolean bl = transitionToExists = this.transitionTo != null;
        if (transitionToExists) {
            builder.field(TRANSITION_TO, this.transitionTo);
        } else {
            XContentUtils.addObject(builder, "state", this.stateMetaData, params);
            XContentUtils.addObject(builder, "action", this.actionMetaData, params);
            XContentUtils.addObject(builder, "step", this.stepMetaData, params);
        }
        XContentUtils.addObject(builder, "retry_info", this.policyRetryInfo, params);
        if (this.info != null) {
            builder.field(INFO, this.info);
        }
        return builder;
    }

    public void writeTo(StreamOutput streamOutput) throws IOException {
        streamOutput.writeString(this.index);
        streamOutput.writeString(this.indexUuid);
        streamOutput.writeString(this.policyID);
        streamOutput.writeOptionalLong(this.policySeqNo);
        streamOutput.writeOptionalLong(this.policyPrimaryTerm);
        streamOutput.writeOptionalBoolean(this.policyCompleted);
        streamOutput.writeOptionalBoolean(this.rolledOver);
        streamOutput.writeOptionalString(this.rolledOverIndexName);
        streamOutput.writeOptionalLong(this.indexCreationDate);
        streamOutput.writeOptionalString(this.transitionTo);
        streamOutput.writeOptionalWriteable((Writeable)this.stateMetaData);
        streamOutput.writeOptionalWriteable((Writeable)this.actionMetaData);
        streamOutput.writeOptionalWriteable((Writeable)this.stepMetaData);
        streamOutput.writeOptionalWriteable((Writeable)this.policyRetryInfo);
        if (this.info == null) {
            streamOutput.writeBoolean(false);
        } else {
            streamOutput.writeBoolean(true);
            streamOutput.writeMap(this.info);
        }
    }

    public String getIndex() {
        return this.index;
    }

    public String getIndexUuid() {
        return this.indexUuid;
    }

    public String getPolicyID() {
        return this.policyID;
    }

    public Long getPolicySeqNo() {
        return this.policySeqNo;
    }

    public Long getPolicyPrimaryTerm() {
        return this.policyPrimaryTerm;
    }

    public Boolean getPolicyCompleted() {
        return this.policyCompleted;
    }

    public Boolean getRolledOver() {
        return this.rolledOver;
    }

    public Long getIndexCreationDate() {
        return this.indexCreationDate;
    }

    public String getTransitionTo() {
        return this.transitionTo;
    }

    public StateMetaData getStateMetaData() {
        return this.stateMetaData;
    }

    public ActionMetaData getActionMetaData() {
        return this.actionMetaData;
    }

    public StepMetaData getStepMetaData() {
        return this.stepMetaData;
    }

    public PolicyRetryInfoMetaData getPolicyRetryInfo() {
        return this.policyRetryInfo;
    }

    public Map<String, Object> getInfo() {
        return this.info;
    }

    public String getId() {
        return this.id;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public String getRolledOverIndexName() {
        return this.rolledOverIndexName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagedIndexMetaData that = (ManagedIndexMetaData)o;
        return this.seqNo == that.seqNo && this.primaryTerm == that.primaryTerm && Objects.equals(this.index, that.index) && Objects.equals(this.indexUuid, that.indexUuid) && Objects.equals(this.policyID, that.policyID) && Objects.equals(this.policySeqNo, that.policySeqNo) && Objects.equals(this.policyPrimaryTerm, that.policyPrimaryTerm) && Objects.equals(this.policyCompleted, that.policyCompleted) && Objects.equals(this.rolledOver, that.rolledOver) && Objects.equals(this.indexCreationDate, that.indexCreationDate) && Objects.equals(this.transitionTo, that.transitionTo) && Objects.equals(this.stateMetaData, that.stateMetaData) && Objects.equals(this.actionMetaData, that.actionMetaData) && Objects.equals(this.stepMetaData, that.stepMetaData) && Objects.equals(this.policyRetryInfo, that.policyRetryInfo) && Objects.equals(this.info, that.info) && Objects.equals(this.id, that.id) && Objects.equals(this.rolledOverIndexName, that.rolledOverIndexName);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.indexUuid, this.policyID, this.policySeqNo, this.policyPrimaryTerm, this.policyCompleted, this.rolledOver, this.indexCreationDate, this.transitionTo, this.stateMetaData, this.actionMetaData, this.stepMetaData, this.policyRetryInfo, this.info, this.id, this.seqNo, this.primaryTerm, this.rolledOverIndexName);
    }

    public String toString() {
        return "ManagedIndexMetaData{index='" + this.index + "', indexUuid='" + this.indexUuid + "', policyID='" + this.policyID + "', policySeqNo=" + this.policySeqNo + ", policyPrimaryTerm=" + this.policyPrimaryTerm + ", policyCompleted=" + this.policyCompleted + ", rolledOver=" + this.rolledOver + ", indexCreationDate=" + this.indexCreationDate + ", transitionTo='" + this.transitionTo + "', stateMetaData=" + String.valueOf(this.stateMetaData) + ", actionMetaData=" + String.valueOf(this.actionMetaData) + ", stepMetaData=" + String.valueOf(this.stepMetaData) + ", policyRetryInfo=" + String.valueOf(this.policyRetryInfo) + ", info=" + String.valueOf(this.info) + ", id='" + this.id + "', seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", rolledOverIndexName='" + this.rolledOverIndexName + "'}";
    }

    public static ManagedIndexMetaData fromStreamInput(StreamInput si) throws IOException {
        String index = si.readString();
        String indexUuid = si.readString();
        String policyID = si.readString();
        Long policySeqNo = si.readOptionalLong();
        Long policyPrimaryTerm = si.readOptionalLong();
        Boolean policyCompleted = si.readOptionalBoolean();
        Boolean rolledOver = si.readOptionalBoolean();
        String rolledOverIndexName = si.readOptionalString();
        Long indexCreationDate = si.readOptionalLong();
        String transitionTo = si.readOptionalString();
        StateMetaData state = (StateMetaData)si.readOptionalWriteable(StateMetaData::fromStreamInput);
        ActionMetaData action = (ActionMetaData)si.readOptionalWriteable(ActionMetaData::fromStreamInput);
        StepMetaData step = (StepMetaData)si.readOptionalWriteable(StepMetaData::fromStreamInput);
        PolicyRetryInfoMetaData retryInfo = (PolicyRetryInfoMetaData)si.readOptionalWriteable(PolicyRetryInfoMetaData::fromStreamInput);
        Map info = si.readBoolean() ? si.readMap() : null;
        return new ManagedIndexMetaData(Objects.requireNonNull(index, "index is null"), Objects.requireNonNull(indexUuid, "index_uuid is null"), Objects.requireNonNull(policyID, "policy_id is null"), policySeqNo, policyPrimaryTerm, policyCompleted, rolledOver, indexCreationDate, transitionTo, state, action, step, retryInfo, info, NO_ID, -2L, 0L, rolledOverIndexName);
    }

    public static ManagedIndexMetaData parse(XContentParser xcp) throws IOException {
        return ManagedIndexMetaData.parse(xcp, NO_ID, -2L, 0L);
    }

    public static ManagedIndexMetaData parse(XContentParser xcp, String id, long seqNo, long primaryTerm) throws IOException {
        String index = null;
        String indexUuid = null;
        String policyID = null;
        Long policySeqNo = null;
        Long policyPrimaryTerm = null;
        Boolean policyCompleted = null;
        Boolean rolledOver = null;
        String rolledOverIndexName = null;
        Long indexCreationDate = null;
        String transitionTo = null;
        StateMetaData state = null;
        ActionMetaData action = null;
        StepMetaData step = null;
        PolicyRetryInfoMetaData retryInfo = null;
        Map info = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "index": {
                    index = xcp.text();
                    break;
                }
                case "index_uuid": {
                    indexUuid = xcp.text();
                    break;
                }
                case "policy_id": {
                    policyID = xcp.text();
                    break;
                }
                case "policy_seq_no": {
                    policySeqNo = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Long.valueOf(xcp.longValue());
                    break;
                }
                case "policy_primary_term": {
                    policyPrimaryTerm = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Long.valueOf(xcp.longValue());
                    break;
                }
                case "policy_completed": {
                    policyCompleted = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Boolean.valueOf(xcp.booleanValue());
                    break;
                }
                case "rolled_over": {
                    rolledOver = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Boolean.valueOf(xcp.booleanValue());
                    break;
                }
                case "rolled_over_index_name": {
                    rolledOverIndexName = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : xcp.text();
                    break;
                }
                case "index_creation_date": {
                    indexCreationDate = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Long.valueOf(xcp.longValue());
                    break;
                }
                case "transition_to": {
                    transitionTo = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : xcp.text();
                    break;
                }
                case "state": {
                    state = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : StateMetaData.parse(xcp);
                    break;
                }
                case "action": {
                    action = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : ActionMetaData.parse(xcp);
                    break;
                }
                case "step": {
                    step = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : StepMetaData.parse(xcp);
                    break;
                }
                case "retry_info": {
                    retryInfo = PolicyRetryInfoMetaData.parse(xcp);
                    break;
                }
                case "info": {
                    info = xcp.map();
                }
            }
        }
        return new ManagedIndexMetaData(Objects.requireNonNull(index, "index is null"), Objects.requireNonNull(indexUuid, "index_uuid is null"), Objects.requireNonNull(policyID, "policy_id is null"), policySeqNo, policyPrimaryTerm, policyCompleted, rolledOver, indexCreationDate, transitionTo, state, action, step, retryInfo, info, id, seqNo, primaryTerm, rolledOverIndexName);
    }

    public static ManagedIndexMetaData parseWithType(XContentParser xcp) throws IOException {
        return ManagedIndexMetaData.parseWithType(xcp, NO_ID, -2L, 0L);
    }

    public static ManagedIndexMetaData parseWithType(XContentParser xcp, String id, long seqNo, long primaryTerm) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        ManagedIndexMetaData managedIndexMetaData = ManagedIndexMetaData.parse(xcp, id, seqNo, primaryTerm);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        return managedIndexMetaData;
    }

    public static ManagedIndexMetaData fromMap(Map<String, String> map) throws IOException {
        return new ManagedIndexMetaData(Objects.requireNonNull(map.get(INDEX), "index is null"), Objects.requireNonNull(map.get(INDEX_UUID), "index_uuid is null"), Objects.requireNonNull(map.get(POLICY_ID), "policy_id is null"), map.get(POLICY_SEQ_NO) != null ? Long.valueOf(Long.parseLong(map.get(POLICY_SEQ_NO))) : null, map.get(POLICY_PRIMARY_TERM) != null ? Long.valueOf(Long.parseLong(map.get(POLICY_PRIMARY_TERM))) : null, map.get(POLICY_COMPLETED) != null ? Boolean.valueOf(Boolean.parseBoolean(map.get(POLICY_COMPLETED))) : null, map.get(ROLLED_OVER) != null ? Boolean.valueOf(Boolean.parseBoolean(map.get(ROLLED_OVER))) : null, map.get(INDEX_CREATION_DATE) != null ? Long.valueOf(Long.parseLong(map.get(INDEX_CREATION_DATE))) : null, map.get(TRANSITION_TO), StateMetaData.fromManagedIndexMetaDataMap(map), ActionMetaData.fromManagedIndexMetaDataMap(map), StepMetaData.fromManagedIndexMetaDataMap(map), PolicyRetryInfoMetaData.fromManagedIndexMetaDataMap(map), map.get(INFO) != null ? XContentHelper.convertToMap((XContent)MediaTypeRegistry.JSON.xContent(), (String)map.get(INFO), (boolean)false) : null, NO_ID, -2L, 0L, map.get(ROLLED_OVER_INDEX_NAME));
    }

    public static class Builder {
        private String index;
        private String indexUuid;
        private String policyID;
        private Long policySeqNo;
        private Long policyPrimaryTerm;
        private Boolean policyCompleted;
        private Boolean rolledOver;
        private Long indexCreationDate;
        private String transitionTo;
        private StateMetaData stateMetaData;
        private ActionMetaData actionMetaData;
        private StepMetaData stepMetaData;
        private PolicyRetryInfoMetaData policyRetryInfo;
        private Map<String, Object> info;
        private String id;
        private long seqNo;
        private long primaryTerm;
        private String rolledOverIndexName;

        public Builder() {
        }

        public Builder(ManagedIndexMetaData metadata) {
            this.index = metadata.index;
            this.indexUuid = metadata.indexUuid;
            this.policyID = metadata.policyID;
            this.policySeqNo = metadata.policySeqNo;
            this.policyPrimaryTerm = metadata.policyPrimaryTerm;
            this.policyCompleted = metadata.policyCompleted;
            this.rolledOver = metadata.rolledOver;
            this.indexCreationDate = metadata.indexCreationDate;
            this.transitionTo = metadata.transitionTo;
            this.stateMetaData = metadata.stateMetaData;
            this.actionMetaData = metadata.actionMetaData;
            this.stepMetaData = metadata.stepMetaData;
            this.policyRetryInfo = metadata.policyRetryInfo;
            this.info = metadata.info;
            this.id = metadata.id;
            this.seqNo = metadata.seqNo;
            this.primaryTerm = metadata.primaryTerm;
            this.rolledOverIndexName = metadata.rolledOverIndexName;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder indexUuid(String indexUuid) {
            this.indexUuid = indexUuid;
            return this;
        }

        public Builder policyID(String policyID) {
            this.policyID = policyID;
            return this;
        }

        public Builder policySeqNo(Long policySeqNo) {
            this.policySeqNo = policySeqNo;
            return this;
        }

        public Builder policyPrimaryTerm(Long policyPrimaryTerm) {
            this.policyPrimaryTerm = policyPrimaryTerm;
            return this;
        }

        public Builder policyCompleted(Boolean policyCompleted) {
            this.policyCompleted = policyCompleted;
            return this;
        }

        public Builder rolledOver(Boolean rolledOver) {
            this.rolledOver = rolledOver;
            return this;
        }

        public Builder indexCreationDate(Long indexCreationDate) {
            this.indexCreationDate = indexCreationDate;
            return this;
        }

        public Builder transitionTo(String transitionTo) {
            this.transitionTo = transitionTo;
            return this;
        }

        public Builder stateMetaData(StateMetaData stateMetaData) {
            this.stateMetaData = stateMetaData;
            return this;
        }

        public Builder actionMetaData(ActionMetaData actionMetaData) {
            this.actionMetaData = actionMetaData;
            return this;
        }

        public Builder stepMetaData(StepMetaData stepMetaData) {
            this.stepMetaData = stepMetaData;
            return this;
        }

        public Builder policyRetryInfo(PolicyRetryInfoMetaData policyRetryInfo) {
            this.policyRetryInfo = policyRetryInfo;
            return this;
        }

        public Builder info(Map<String, Object> info) {
            this.info = info;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder seqNo(long seqNo) {
            this.seqNo = seqNo;
            return this;
        }

        public Builder primaryTerm(long primaryTerm) {
            this.primaryTerm = primaryTerm;
            return this;
        }

        public Builder rolledOverIndexName(String rolledOverIndexName) {
            this.rolledOverIndexName = rolledOverIndexName;
            return this;
        }

        public ManagedIndexMetaData build() {
            return new ManagedIndexMetaData(this.index, this.indexUuid, this.policyID, this.policySeqNo, this.policyPrimaryTerm, this.policyCompleted, this.rolledOver, this.indexCreationDate, this.transitionTo, this.stateMetaData, this.actionMetaData, this.stepMetaData, this.policyRetryInfo, this.info, this.id, this.seqNo, this.primaryTerm, this.rolledOverIndexName);
        }
    }
}

