/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.model;

import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;

public class PolicyRetryInfoMetaData
implements Writeable,
ToXContentFragment {
    public static final String RETRY_INFO = "retry_info";
    public static final String FAILED = "failed";
    public static final String CONSUMED_RETRIES = "consumed_retries";
    private final boolean failed;
    private final int consumedRetries;

    public PolicyRetryInfoMetaData(boolean failed, int consumedRetries) {
        this.failed = failed;
        this.consumedRetries = consumedRetries;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.failed);
        out.writeInt(this.consumedRetries);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field(FAILED, this.failed).field(CONSUMED_RETRIES, this.consumedRetries);
    }

    public String getMapValueString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    public boolean getFailed() {
        return this.failed;
    }

    public int getConsumedRetries() {
        return this.consumedRetries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyRetryInfoMetaData that = (PolicyRetryInfoMetaData)o;
        return this.failed == that.failed && this.consumedRetries == that.consumedRetries;
    }

    public int hashCode() {
        return Objects.hash(this.failed, this.consumedRetries);
    }

    public String toString() {
        return "PolicyRetryInfoMetaData{failed=" + this.failed + ", consumedRetries=" + this.consumedRetries + "}";
    }

    public static PolicyRetryInfoMetaData fromStreamInput(StreamInput si) throws IOException {
        Boolean failed = si.readBoolean();
        Integer consumedRetries = si.readInt();
        return new PolicyRetryInfoMetaData(Objects.requireNonNull(failed, "failed is null"), Objects.requireNonNull(consumedRetries, "consumed_retries is null"));
    }

    public static PolicyRetryInfoMetaData fromManagedIndexMetaDataMap(Map<String, String> map) throws IOException {
        String stateJsonString = map.get(RETRY_INFO);
        if (stateJsonString != null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(stateJsonString.getBytes(StandardCharsets.UTF_8));
            XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)inputStream);
            parser.nextToken();
            return PolicyRetryInfoMetaData.parse(parser);
        }
        return null;
    }

    public static PolicyRetryInfoMetaData parse(XContentParser xcp) throws IOException {
        Boolean failed = null;
        Integer consumedRetries = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "failed": {
                    failed = xcp.booleanValue();
                    break;
                }
                case "consumed_retries": {
                    consumedRetries = xcp.intValue();
                }
            }
        }
        return new PolicyRetryInfoMetaData((Boolean)Objects.requireNonNull(failed, "failed is null"), (Integer)Objects.requireNonNull(consumedRetries, "consumed_retries is null"));
    }
}

