/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.model;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class ShrinkActionProperties
implements Writeable,
ToXContentFragment {
    public static final String SHRINK_ACTION_PROPERTIES = "shrink_action_properties";
    private final String nodeName;
    private final String targetIndexName;
    private final int targetNumShards;
    private final long lockPrimaryTerm;
    private final long lockSeqNo;
    private final long lockEpochSecond;
    private final long lockDurationSecond;
    private final Map<String, String> originalIndexSettings;

    public ShrinkActionProperties(String nodeName, String targetIndexName, int targetNumShards, long lockPrimaryTerm, long lockSeqNo, long lockEpochSecond, long lockDurationSecond, Map<String, String> originalIndexSettings) {
        this.nodeName = nodeName;
        this.targetIndexName = targetIndexName;
        this.targetNumShards = targetNumShards;
        this.lockPrimaryTerm = lockPrimaryTerm;
        this.lockSeqNo = lockSeqNo;
        this.lockEpochSecond = lockEpochSecond;
        this.lockDurationSecond = lockDurationSecond;
        this.originalIndexSettings = originalIndexSettings;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeName);
        out.writeString(this.targetIndexName);
        out.writeInt(this.targetNumShards);
        out.writeLong(this.lockPrimaryTerm);
        out.writeLong(this.lockSeqNo);
        out.writeLong(this.lockEpochSecond);
        out.writeLong(this.lockDurationSecond);
        out.writeMap(this.originalIndexSettings, StreamOutput::writeString, StreamOutput::writeString);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(ShrinkProperties.NODE_NAME.getKey(), this.nodeName);
        builder.field(ShrinkProperties.TARGET_INDEX_NAME.getKey(), this.targetIndexName);
        builder.field(ShrinkProperties.TARGET_NUM_SHARDS.getKey(), this.targetNumShards);
        builder.field(ShrinkProperties.LOCK_SEQ_NO.getKey(), this.lockSeqNo);
        builder.field(ShrinkProperties.LOCK_PRIMARY_TERM.getKey(), this.lockPrimaryTerm);
        builder.field(ShrinkProperties.LOCK_EPOCH_SECOND.getKey(), this.lockEpochSecond);
        builder.field(ShrinkProperties.LOCK_DURATION_SECOND.getKey(), this.lockDurationSecond);
        builder.field(ShrinkProperties.ORIGINAL_INDEX_SETTINGS.getKey(), this.originalIndexSettings);
        return builder;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getTargetIndexName() {
        return this.targetIndexName;
    }

    public int getTargetNumShards() {
        return this.targetNumShards;
    }

    public long getLockPrimaryTerm() {
        return this.lockPrimaryTerm;
    }

    public long getLockSeqNo() {
        return this.lockSeqNo;
    }

    public long getLockEpochSecond() {
        return this.lockEpochSecond;
    }

    public long getLockDurationSecond() {
        return this.lockDurationSecond;
    }

    public Map<String, String> getOriginalIndexSettings() {
        return this.originalIndexSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShrinkActionProperties that = (ShrinkActionProperties)o;
        return this.targetNumShards == that.targetNumShards && this.lockPrimaryTerm == that.lockPrimaryTerm && this.lockSeqNo == that.lockSeqNo && this.lockEpochSecond == that.lockEpochSecond && this.lockDurationSecond == that.lockDurationSecond && Objects.equals(this.nodeName, that.nodeName) && Objects.equals(this.targetIndexName, that.targetIndexName) && Objects.equals(this.originalIndexSettings, that.originalIndexSettings);
    }

    public int hashCode() {
        return Objects.hash(this.nodeName, this.targetIndexName, this.targetNumShards, this.lockPrimaryTerm, this.lockSeqNo, this.lockEpochSecond, this.lockDurationSecond, this.originalIndexSettings);
    }

    public String toString() {
        return "ShrinkActionProperties{nodeName='" + this.nodeName + "', targetIndexName='" + this.targetIndexName + "', targetNumShards=" + this.targetNumShards + ", lockPrimaryTerm=" + this.lockPrimaryTerm + ", lockSeqNo=" + this.lockSeqNo + ", lockEpochSecond=" + this.lockEpochSecond + ", lockDurationSecond=" + this.lockDurationSecond + ", originalIndexSettings=" + String.valueOf(this.originalIndexSettings) + "}";
    }

    public static ShrinkActionProperties fromStreamInput(StreamInput si) throws IOException {
        String nodeName = si.readString();
        String targetIndexName = si.readString();
        int targetNumShards = si.readInt();
        long lockPrimaryTerm = si.readLong();
        long lockSeqNo = si.readLong();
        long lockEpochSecond = si.readLong();
        long lockDurationSecond = si.readLong();
        Map originalIndexSettings = si.readMap(StreamInput::readString, StreamInput::readString);
        return new ShrinkActionProperties(nodeName, targetIndexName, targetNumShards, lockPrimaryTerm, lockSeqNo, lockEpochSecond, lockDurationSecond, originalIndexSettings);
    }

    public static ShrinkActionProperties parse(XContentParser xcp) throws IOException {
        String nodeName = null;
        String targetIndexName = null;
        Integer targetNumShards = null;
        Long lockPrimaryTerm = null;
        Long lockSeqNo = null;
        Long lockEpochSecond = null;
        Long lockDurationSecond = null;
        Map originalIndexSettings = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "node_name": {
                    nodeName = xcp.text();
                    break;
                }
                case "target_index_name": {
                    targetIndexName = xcp.text();
                    break;
                }
                case "target_num_shards": {
                    targetNumShards = xcp.intValue();
                    break;
                }
                case "lock_primary_term": {
                    lockPrimaryTerm = xcp.longValue();
                    break;
                }
                case "lock_seq_no": {
                    lockSeqNo = xcp.longValue();
                    break;
                }
                case "lock_epoch_second": {
                    lockEpochSecond = xcp.longValue();
                    break;
                }
                case "lock_duration_second": {
                    lockDurationSecond = xcp.longValue();
                    break;
                }
                case "original_index_settings": {
                    originalIndexSettings = xcp.mapStrings();
                }
            }
        }
        return new ShrinkActionProperties(Objects.requireNonNull(nodeName), Objects.requireNonNull(targetIndexName), (Integer)Objects.requireNonNull(targetNumShards), (Long)Objects.requireNonNull(lockPrimaryTerm), (Long)Objects.requireNonNull(lockSeqNo), Objects.requireNonNull(lockEpochSecond), Objects.requireNonNull(lockDurationSecond), Objects.requireNonNull(originalIndexSettings));
    }

    public static enum ShrinkProperties {
        NODE_NAME("node_name"),
        TARGET_INDEX_NAME("target_index_name"),
        TARGET_NUM_SHARDS("target_num_shards"),
        LOCK_SEQ_NO("lock_seq_no"),
        LOCK_PRIMARY_TERM("lock_primary_term"),
        LOCK_EPOCH_SECOND("lock_epoch_second"),
        LOCK_DURATION_SECOND("lock_duration_second"),
        ORIGINAL_INDEX_SETTINGS("original_index_settings");

        private final String key;

        private ShrinkProperties(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

