/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.model;

import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;

public class StateMetaData
implements Writeable,
ToXContentFragment {
    public static final String STATE = "state";
    private final String name;
    private final long startTime;

    public StateMetaData(String name, long startTime) {
        this.name = name;
        this.startTime = startTime;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeLong(this.startTime);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field("name", this.name).field("start_time", this.startTime);
    }

    public String getMapValueString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    public String getName() {
        return this.name;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateMetaData that = (StateMetaData)o;
        return this.startTime == that.startTime && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.startTime);
    }

    public String toString() {
        return "StateMetaData{name='" + this.name + "', startTime=" + this.startTime + "}";
    }

    public static StateMetaData fromStreamInput(StreamInput si) throws IOException {
        String name = si.readString();
        Long startTime = si.readLong();
        return new StateMetaData(Objects.requireNonNull(name, "name is null"), Objects.requireNonNull(startTime, "start_time is null"));
    }

    public static StateMetaData fromManagedIndexMetaDataMap(Map<String, String> map) throws IOException {
        String stateJsonString = map.get(STATE);
        if (stateJsonString != null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(stateJsonString.getBytes(StandardCharsets.UTF_8));
            XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)inputStream);
            parser.nextToken();
            return StateMetaData.parse(parser);
        }
        return null;
    }

    public static StateMetaData parse(XContentParser xcp) throws IOException {
        String name = null;
        Long startTime = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "name": {
                    name = xcp.text();
                    break;
                }
                case "start_time": {
                    startTime = xcp.longValue();
                }
            }
        }
        return new StateMetaData(Objects.requireNonNull(name, "name is null"), (Long)Objects.requireNonNull(startTime, "start_time is null"));
    }
}

