/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.model;

import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.indexmanagement.Step;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class StepMetaData
implements Writeable,
ToXContentFragment {
    public static final String STEP = "step";
    public static final String STEP_STATUS = "step_status";
    private final String name;
    private final long startTime;
    private final Step.StepStatus stepStatus;

    public StepMetaData(String name, long startTime, Step.StepStatus stepStatus) {
        this.name = name;
        this.startTime = startTime;
        this.stepStatus = stepStatus;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeLong(this.startTime);
        this.stepStatus.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("name", this.name).field("start_time", this.startTime).field(STEP_STATUS, this.stepStatus.toString());
        return builder;
    }

    public String getMapValueString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    public String getName() {
        return this.name;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Step.StepStatus getStepStatus() {
        return this.stepStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StepMetaData that = (StepMetaData)o;
        return this.startTime == that.startTime && Objects.equals(this.name, that.name) && this.stepStatus == that.stepStatus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.startTime, this.stepStatus});
    }

    public String toString() {
        return "StepMetaData{name='" + this.name + "', startTime=" + this.startTime + ", stepStatus=" + String.valueOf((Object)this.stepStatus) + "}";
    }

    public static StepMetaData fromStreamInput(StreamInput si) throws IOException {
        String name = si.readString();
        Long startTime = si.readLong();
        Step.StepStatus stepStatus = Step.StepStatus.read(si);
        return new StepMetaData(Objects.requireNonNull(name, "name is null"), Objects.requireNonNull(startTime, "start_time is null"), Objects.requireNonNull(stepStatus, "step_status is null"));
    }

    public static StepMetaData fromManagedIndexMetaDataMap(Map<String, String> map) throws IOException {
        String stepJsonString = map.get(STEP);
        if (stepJsonString != null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(stepJsonString.getBytes(StandardCharsets.UTF_8));
            XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)inputStream);
            parser.nextToken();
            return StepMetaData.parse(parser);
        }
        return null;
    }

    public static StepMetaData parse(XContentParser xcp) throws IOException {
        String name = null;
        Long startTime = null;
        Step.StepStatus stepStatus = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "name": {
                    name = xcp.text();
                    break;
                }
                case "start_time": {
                    startTime = xcp.longValue();
                    break;
                }
                case "step_status": {
                    stepStatus = Step.StepStatus.valueOf(xcp.text().toUpperCase(Locale.ROOT));
                }
            }
        }
        return new StepMetaData(Objects.requireNonNull(name, "name is null"), (Long)Objects.requireNonNull(startTime, "start_time is null"), Objects.requireNonNull(stepStatus, "step_status is null"));
    }
}

