/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.model;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Objects;

public class TransformActionProperties
implements Writeable,
ToXContentFragment {
    public static final String TRANSFORM_ACTION_PROPERTIES = "transform_action_properties";
    private final String transformId;

    public TransformActionProperties(String transformId) {
        this.transformId = transformId;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.transformId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.transformId != null) {
            builder.field(Properties.TRANSFORM_ID.getKey(), this.transformId);
        }
        return builder;
    }

    public String getTransformId() {
        return this.transformId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformActionProperties that = (TransformActionProperties)o;
        return Objects.equals(this.transformId, that.transformId);
    }

    public int hashCode() {
        return Objects.hash(this.transformId);
    }

    public String toString() {
        return "TransformActionProperties{transformId='" + this.transformId + "'}";
    }

    public static TransformActionProperties fromStreamInput(StreamInput sin) throws IOException {
        String transformId = sin.readOptionalString();
        return new TransformActionProperties(transformId);
    }

    public static TransformActionProperties parse(XContentParser xcp) throws IOException {
        String transformId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            if (!fieldName.equals(Properties.TRANSFORM_ID.getKey())) continue;
            transformId = xcp.text();
        }
        return new TransformActionProperties(transformId);
    }

    public static enum Properties {
        TRANSFORM_ID("transform_id");

        private final String key;

        private Properties(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

