/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.indexmanagement.model;

import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.indexmanagement.Validate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class ValidationResult
implements Writeable,
ToXContentFragment {
    public static final String VALIDATE = "validate";
    public static final String VALIDATION_MESSAGE = "validation_message";
    public static final String VALIDATION_STATUS = "validation_status";
    private final String validationMessage;
    private final Validate.ValidationStatus validationStatus;

    public ValidationResult(String validationMessage, Validate.ValidationStatus validationStatus) {
        this.validationMessage = validationMessage;
        this.validationStatus = validationStatus;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.validationMessage);
        this.validationStatus.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(VALIDATION_MESSAGE, this.validationMessage).field(VALIDATION_STATUS, this.validationStatus.toString());
        return builder;
    }

    public String getMapValueString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    public String getValidationMessage() {
        return this.validationMessage;
    }

    public Validate.ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationResult that = (ValidationResult)o;
        return Objects.equals(this.validationMessage, that.validationMessage) && this.validationStatus == that.validationStatus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.validationMessage, this.validationStatus});
    }

    public String toString() {
        return "ValidationResult{validationMessage='" + this.validationMessage + "', validationStatus=" + String.valueOf((Object)this.validationStatus) + "}";
    }

    public static ValidationResult fromStreamInput(StreamInput si) throws IOException {
        String validationMessage = si.readString();
        Validate.ValidationStatus validationStatus = Validate.ValidationStatus.read(si);
        return new ValidationResult(Objects.requireNonNull(validationMessage, "validation_message is null"), Objects.requireNonNull(validationStatus, "validation_status is null"));
    }

    public static ValidationResult fromManagedIndexMetaDataMap(Map<String, String> map) throws IOException {
        String stepJsonString = map.get(VALIDATE);
        if (stepJsonString != null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(stepJsonString.getBytes(StandardCharsets.UTF_8));
            XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)inputStream);
            parser.nextToken();
            return ValidationResult.parse(parser);
        }
        return null;
    }

    public static ValidationResult parse(XContentParser xcp) throws IOException {
        String validationMessage = null;
        Validate.ValidationStatus validationStatus = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "validation_message": {
                    validationMessage = xcp.text();
                    break;
                }
                case "validation_status": {
                    validationStatus = Validate.ValidationStatus.valueOf(xcp.text().toUpperCase(Locale.ROOT));
                }
            }
        }
        return new ValidationResult(Objects.requireNonNull(validationMessage, "validation_message is null"), Objects.requireNonNull(validationStatus, "validation_status is null"));
    }
}

