/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config;

import com.oracle.labs.mlrg.olcut.config.ArgumentException;
import com.oracle.labs.mlrg.olcut.config.Option;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public interface Options {
    public static final List<String> header = Collections.unmodifiableList(Arrays.asList("Char", "Long Name", "Type", "Default", "Usage"));

    default public String getOptionsDescription() {
        return "";
    }

    public static String formatUsage(List<List<String>> usageList) {
        int[] maxWidth = new int[5];
        for (List<String> a : usageList) {
            if (a.size() != 5) continue;
            if (maxWidth[0] < a.get(0).length()) {
                maxWidth[0] = a.get(0).length();
            }
            if (maxWidth[1] < a.get(1).length()) {
                maxWidth[1] = a.get(1).length();
            }
            if (maxWidth[2] < a.get(2).length()) {
                maxWidth[2] = a.get(2).length();
            }
            if (maxWidth[3] >= a.get(3).length()) continue;
            maxWidth[3] = a.get(3).length();
        }
        String formatString = "%" + maxWidth[0] + "s %-" + maxWidth[1] + "s %-" + maxWidth[2] + "s %-" + maxWidth[3] + "s %s\n";
        StringBuilder builder = new StringBuilder();
        for (List<String> a : usageList) {
            if (a.size() == 5) {
                builder.append(String.format(formatString, a.get(0), a.get(1), a.get(2), a.get(3), a.get(4)));
                continue;
            }
            if (a.size() == 2) {
                builder.append(a.get(0));
                builder.append(a.get(1));
                builder.append("\n");
                continue;
            }
            builder.append("\n");
            builder.append(a.get(0));
            builder.append("\n\n");
        }
        return builder.toString();
    }

    public static List<List<String>> getUsage(Class<? extends Options> options) {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        ArrayList<ArrayList<String>> optionsList = new ArrayList<ArrayList<String>>();
        Set<Field> fields = Options.getOptionFields(options);
        if (fields.size() == 0) {
            return list;
        }
        list.add(new ArrayList<String>(Collections.singletonList(options.getSimpleName())));
        try {
            Options opt = options.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            String optUsage = opt.getOptionsDescription();
            if (!optUsage.isEmpty()) {
                list.add(Arrays.asList("Description: ", optUsage));
            }
            list.add(header);
            for (Field f : fields) {
                Option option = f.getAnnotation(Option.class);
                optionsList.add(Options.getOptionUsage(option, f, opt));
            }
            optionsList.sort((a, b) -> {
                if (((String)a.get(0)).charAt(0) == ((String)b.get(0)).charAt(0)) {
                    return ((String)a.get(1)).compareTo((String)b.get(1));
                }
                if (((String)a.get(0)).charAt(0) == ' ') {
                    return 1;
                }
                if (((String)b.get(0)).charAt(0) == ' ') {
                    return -1;
                }
                return ((String)a.get(0)).compareTo((String)b.get(0));
            });
            list.addAll(optionsList);
            return list;
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ArgumentException(e, "Could not instantiate Options class " + options.getName() + ", it has no default constructor.");
        }
        catch (IllegalAccessException e) {
            if (!Modifier.isPublic(options.getModifiers())) {
                throw new ArgumentException(e, "Could not instantiate Options class " + options.getName() + ", it must be public.");
            }
            try {
                Constructor<? extends Options> constructor = options.getDeclaredConstructor(new Class[0]);
                if (!Modifier.isPublic(constructor.getModifiers())) {
                    throw new ArgumentException(e, "Could not instantiate Options class " + options.getName() + ", its default constructor must be public.");
                }
            }
            catch (NoSuchMethodException nsme) {
                throw new ArgumentException(e, "Could not instantiate Options class " + options.getName() + ", it has no default constructor.");
            }
            throw new ArgumentException(e, "Could not instantiate Options class " + options.getName());
        }
    }

    public static String getEnumConstantString(Class<? extends Enum<?>> enumClazz) {
        Enum<?>[] constants = enumClazz.getEnumConstants();
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Enum<?> o : constants) {
            sb.append(o.name());
            sb.append(", ");
        }
        sb.replace(sb.length() - 2, sb.length(), "}");
        return sb.toString();
    }

    public static String generateTypeDescription(Field f) {
        Class<?> clazz = f.getType();
        if (clazz.isEnum()) {
            Class<?> enumClazz = clazz;
            return "enum - " + Options.getEnumConstantString(enumClazz);
        }
        if (clazz == EnumSet.class) {
            Type type = f.getGenericType();
            if (type instanceof ParameterizedType) {
                ParameterizedType typeName = (ParameterizedType)type;
                Type enumType = typeName.getActualTypeArguments()[0];
                try {
                    Class<?> enumClazz = Class.forName(enumType.getTypeName());
                    return "EnumSet - " + Options.getEnumConstantString(enumClazz);
                }
                catch (ClassNotFoundException e) {
                    Logger.getLogger(Options.class.getName()).warning("Failed to load enum class '" + enumType.getTypeName() + "'");
                    return typeName.getTypeName();
                }
            }
            return f.getGenericType().getTypeName();
        }
        return f.getGenericType().getTypeName();
    }

    public static ArrayList<String> getOptionUsage(Option option, Field f, Options obj) {
        String typeString = Options.generateTypeDescription(f);
        return Options.getOptionUsage(option, f, obj, typeString);
    }

    public static ArrayList<String> getOptionUsage(Option option, String type) {
        ArrayList<String> output = new ArrayList<String>();
        if (option.charName() != '\u0000') {
            output.add("" + option.charName());
        } else {
            output.add(" ");
        }
        output.add(option.longName());
        output.add(type);
        output.add("");
        output.add(option.usage());
        return output;
    }

    public static ArrayList<String> getOptionUsage(Option option, Field f, Options obj, String type) {
        ArrayList<String> output = new ArrayList<String>();
        if (option.charName() != '\u0000') {
            output.add("" + option.charName());
        } else {
            output.add(" ");
        }
        output.add(option.longName());
        output.add(type);
        Object extractedField = AccessController.doPrivileged(() -> {
            try {
                boolean accessible = f.isAccessible();
                f.setAccessible(true);
                Object fieldVal = f.get(obj);
                f.setAccessible(accessible);
                return fieldVal;
            }
            catch (IllegalAccessException e) {
                Logger.getLogger(Options.class.getName()).fine("Failed to read default value from field " + option.longName());
                return null;
            }
        });
        String defaultVal = extractedField == null ? "" : extractedField.toString();
        output.add(defaultVal);
        output.add(option.usage());
        return output;
    }

    public static Set<Field> getOptionFields(Class<? extends Options> options) {
        return AccessController.doPrivileged(() -> {
            HashSet<Field> ret = new HashSet<Field>();
            ArrayDeque cq = new ArrayDeque();
            cq.add(options);
            while (!cq.isEmpty()) {
                Class curr = (Class)cq.remove();
                for (Field f2 : curr.getDeclaredFields()) {
                    if (f2.getAnnotation(Option.class) == null) continue;
                    ret.add(f2);
                }
                for (Field f2 : curr.getFields()) {
                    if (f2.getAnnotation(Option.class) == null) continue;
                    ret.add(f2);
                }
                Class sc = curr.getSuperclass();
                if (sc != null) {
                    cq.add(sc);
                }
                cq.addAll(Arrays.asList(curr.getInterfaces()));
            }
            ret.removeIf(f -> Modifier.isStatic(f.getModifiers()));
            return ret;
        });
    }

    public static Set<Field> getOptions(Class<? extends Options> options) {
        return AccessController.doPrivileged(() -> {
            HashSet<Field> ret = new HashSet<Field>();
            ArrayDeque cq = new ArrayDeque();
            cq.add(options);
            while (!cq.isEmpty()) {
                Class curr = (Class)cq.remove();
                for (Field f2 : curr.getDeclaredFields()) {
                    if (!Options.class.isAssignableFrom(f2.getType())) continue;
                    ret.add(f2);
                }
                for (Field f2 : curr.getFields()) {
                    if (!Options.class.isAssignableFrom(f2.getType())) continue;
                    ret.add(f2);
                }
                Class sc = curr.getSuperclass();
                if (sc != null) {
                    cq.add(sc);
                }
                cq.addAll(Arrays.asList(curr.getInterfaces()));
            }
            ret.removeIf(f -> Modifier.isStatic(f.getModifiers()));
            return ret;
        });
    }

    public static Set<Class<? extends Options>> getAllOptions(Class<? extends Options> options) {
        return AccessController.doPrivileged(() -> {
            LinkedHashMap<Class, Pair> ret = new LinkedHashMap<Class, Pair>();
            HashMap tempSet = new HashMap();
            ret.put(options, new Pair<String, String>("root", "root"));
            ArrayDeque<Class> cq = new ArrayDeque<Class>();
            cq.add(options);
            while (!cq.isEmpty()) {
                Class<?> nextOptions;
                Class curr = (Class)cq.remove();
                String currName = curr.getName();
                for (Field f : curr.getDeclaredFields()) {
                    if (!Options.class.isAssignableFrom(f.getType()) || Modifier.isStatic(f.getModifiers())) continue;
                    nextOptions = f.getType();
                    tempSet.put(new Pair<String, String>(currName, f.getName()), nextOptions);
                }
                for (Field f : curr.getFields()) {
                    if (!Options.class.isAssignableFrom(f.getType()) || Modifier.isStatic(f.getModifiers())) continue;
                    nextOptions = f.getType();
                    tempSet.put(new Pair<String, String>(currName, f.getName()), nextOptions);
                }
                Class sc = curr.getSuperclass();
                if (sc != null) {
                    cq.add(sc);
                }
                cq.addAll(Arrays.asList(curr.getInterfaces()));
                for (Map.Entry e : tempSet.entrySet()) {
                    if (ret.containsKey(e.getValue())) {
                        Pair otherOccurrence = (Pair)ret.get(e.getValue());
                        String firstOccurrence = (String)otherOccurrence.getA() + "." + (String)otherOccurrence.getB();
                        String thisOccurrence = (String)((Pair)e.getKey()).getA() + "." + (String)((Pair)e.getKey()).getB();
                        throw new ArgumentException(firstOccurrence, thisOccurrence, "There are two instances of " + ((Class)e.getValue()).getName() + " in this Options tree.");
                    }
                    ret.put((Class)e.getValue(), (Pair)e.getKey());
                    cq.add((Class)e.getValue());
                }
                tempSet.clear();
            }
            return new LinkedHashSet(ret.keySet());
        });
    }
}

