/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config;

import com.oracle.labs.mlrg.olcut.config.ComponentListener;
import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.ConfigManager;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.config.ConfigurableMXBean;
import com.oracle.labs.mlrg.olcut.config.ConfigurableName;
import com.oracle.labs.mlrg.olcut.config.ConfigurationData;
import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.FieldType;
import com.oracle.labs.mlrg.olcut.config.InternalConfigurationException;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.config.property.ListProperty;
import com.oracle.labs.mlrg.olcut.config.property.MapProperty;
import com.oracle.labs.mlrg.olcut.config.property.Property;
import com.oracle.labs.mlrg.olcut.config.property.SimpleProperty;
import com.oracle.labs.mlrg.olcut.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class PropertySheet<T extends Configurable> {
    private static final Logger logger = Logger.getLogger(PropertySheet.class.getName());
    private final Map<String, Config> registeredProperties = new HashMap<String, Config>();
    private final Map<String, Property> propValues = new HashMap<String, Property>();
    private final Set<String> redacted = new HashSet<String>();
    protected ConfigurationManager cm;
    protected T owner = null;
    protected final Class<T> ownerClass;
    protected final String instanceName;
    protected final ConfigurationData data;

    protected PropertySheet(T configurable, ConfigurationManager cm, ConfigurationData rpd) {
        this(configurable.getClass(), cm, rpd);
        this.owner = configurable;
    }

    protected PropertySheet(Class<T> confClass, ConfigurationManager cm, ConfigurationData rpd) {
        this.ownerClass = confClass;
        this.cm = cm;
        this.instanceName = rpd.getName();
        this.data = rpd;
        PropertySheet.processAnnotations(this, confClass);
        for (String propName : rpd.getProperties().keySet()) {
            if (this.propValues.containsKey(propName)) continue;
            throw new PropertyException(this.instanceName, propName, "Unknown property in configuration file.");
        }
        this.propValues.putAll(rpd.getProperties());
    }

    protected PropertySheet(PropertySheet<T> other) {
        this.ownerClass = other.ownerClass;
        this.cm = other.cm;
        this.instanceName = other.instanceName;
        this.data = other.data;
        this.propValues.putAll(other.propValues);
        this.redacted.addAll(other.redacted);
    }

    public boolean isExportable() {
        return this.data.isExportable();
    }

    public boolean isImportable() {
        return this.data.isImportable();
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.propValues.keySet());
    }

    public Set<String> getRedactedFieldNames() {
        return Collections.unmodifiableSet(this.redacted);
    }

    private void registerProperty(String propName, Config property) {
        assert (property != null && propName != null);
        this.registeredProperties.put(propName, property);
        this.propValues.put(propName, null);
    }

    private String flattenProp(String name) {
        Property value = this.propValues.get(name);
        if (value == null) {
            return null;
        }
        return this.flattenString(name, value.toString());
    }

    private String flattenString(String name, String value) {
        return this.cm.getImmutableGlobalProperties().replaceGlobalProperties(this.getInstanceName(), name, value);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public long getLeaseTime() {
        return this.data.getLeaseTime();
    }

    public String getEntriesName() {
        return this.data.getEntriesName();
    }

    public synchronized boolean isInstantiated() {
        return this.owner != null;
    }

    public Class<T> getOwnerClass() {
        return this.ownerClass;
    }

    public T getOwner() {
        return this.getOwner(null);
    }

    public synchronized T getOwner(boolean reuseComponent) {
        return this.getOwner(null, reuseComponent);
    }

    public synchronized T getOwner(ComponentListener<T> cl) {
        return this.getOwner(cl, true);
    }

    public synchronized T getOwner(ComponentListener<T> cl, boolean reuseComponent) {
        block15: {
            try {
                Object actualLocation;
                Configurable obj;
                if (this.isInstantiated() && reuseComponent) break block15;
                if (this.data.getSerializedForm() != null && (obj = AccessController.doPrivileged(() -> this.lambda$getOwner$0((String)(actualLocation = this.flattenString("", this.data.getSerializedForm()))))) != null) {
                    this.owner = obj;
                    return (T)obj;
                }
                if (this.ownerClass.isInterface()) {
                    throw new PropertyException(this.instanceName, "Failed to lookup interface " + this.ownerClass.getName() + " in registry, or deserialise it.");
                }
                logger.finer(String.format("Creating %s", this.getInstanceName()));
                if (this.cm.showCreations()) {
                    logger.info("CM using:");
                    for (URL u : this.cm.getConfigURLs()) {
                        logger.info(u.toString());
                    }
                    logger.info(String.format("Creating %s type %s", this.instanceName, this.ownerClass.getName()));
                }
                this.owner = AccessController.doPrivileged(() -> {
                    Configurable newObj;
                    try {
                        Constructor<T> constructor = this.ownerClass.getDeclaredConstructor(new Class[0]);
                        boolean isAccessible = constructor.isAccessible();
                        constructor.setAccessible(true);
                        newObj = (Configurable)constructor.newInstance(new Object[0]);
                        constructor.setAccessible(isAccessible);
                    }
                    catch (NoSuchMethodException ex) {
                        throw new PropertyException(ex, this.instanceName, null, "No-args constructor not found for class " + this.ownerClass);
                    }
                    catch (InvocationTargetException ex) {
                        throw new InternalConfigurationException(ex, this.instanceName, null, "Can't instantiate class " + this.ownerClass);
                    }
                    PropertySheet.setConfiguredFields(newObj, this);
                    return newObj;
                });
                try {
                    this.owner.postConfig();
                }
                catch (IOException e) {
                    throw new PropertyException(e, this.instanceName, null, "IOException thrown by postConfig");
                }
                catch (PropertyException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw new PropertyException(e, this.instanceName, null, "RuntimeException thrown by postConfig");
                }
                if (!(this.owner instanceof ConfigurableMXBean)) break block15;
                MBeanServer mbs = this.cm.getMBeanServer();
                String on = String.format("%s:type=%s,name=%s", this.ownerClass.getPackage().getName(), this.ownerClass.getSimpleName(), this.instanceName);
                try {
                    ObjectName oname = new ObjectName(on);
                    if (mbs != null) {
                        mbs.registerMBean(this.owner, oname);
                    }
                }
                catch (Exception e) {
                    throw new PropertyException(e, this.instanceName, null, null);
                }
            }
            catch (PrivilegedActionException e) {
                Exception inner = e.getException();
                if (inner instanceof IllegalAccessException) {
                    throw new InternalConfigurationException(inner, this.getInstanceName(), null, "Can't access class " + this.ownerClass);
                }
                if (inner instanceof InstantiationException) {
                    throw new InternalConfigurationException(inner, this.getInstanceName(), null, "Can't instantiate class " + this.ownerClass);
                }
                throw new InternalConfigurationException(inner, this.getInstanceName(), null, "Unexpected exception thrown by " + this.ownerClass);
            }
        }
        return this.owner;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T extends Configurable> void setConfiguredFields(T o, PropertySheet<T> ps) throws PropertyException, IllegalAccessException {
        Class<?> curClass = o.getClass();
        Set<Field> fields = PropertySheet.getAllFields(curClass);
        Iterator<Field> iterator = fields.iterator();
        while (true) {
            boolean accessible;
            Field f;
            block20: {
                ConfigManager cmAnnotation;
                ConfigurableName nameAnnotation;
                block18: {
                    List<Class<?>> genericList;
                    FieldType ft;
                    block19: {
                        if (!iterator.hasNext()) {
                            return;
                        }
                        f = iterator.next();
                        accessible = f.isAccessible();
                        f.setAccessible(true);
                        Config configAnnotation = f.getAnnotation(Config.class);
                        nameAnnotation = f.getAnnotation(ConfigurableName.class);
                        cmAnnotation = f.getAnnotation(ConfigManager.class);
                        if (configAnnotation == null) break block18;
                        ft = FieldType.getFieldType(f);
                        if (ft == null) {
                            throw new PropertyException(ps.getInstanceName(), f.getName(), f.getName() + " has an unknown field type");
                        }
                        logger.log(Level.FINEST, "Found field of type " + ft.name());
                        if (ps.propValues.get(f.getName()) == null) {
                            if (!configAnnotation.mandatory()) continue;
                            throw new PropertyException(ps.getInstanceName(), f.getName(), f.getName() + " is mandatory in configuration");
                        }
                        if (!FieldType.arrayTypes.contains((Object)ft)) break block19;
                        ListProperty vals = (ListProperty)ps.propValues.get(f.getName());
                        f.set(o, PropertySheet.parseArrayField(ps.getConfigurationManager(), ps.getInstanceName(), f.getName(), f.getType(), ft, vals));
                        break block20;
                    }
                    if (FieldType.listTypes.contains((Object)ft)) {
                        genericList = PropertySheet.getGenericClass(f);
                        if (genericList.size() != 1) {
                            f.setAccessible(accessible);
                            throw new PropertyException(ps.getInstanceName(), f.getName(), "Failed to extract generic type arguments from field. Found: " + genericList.toString());
                        }
                        ListProperty vals = (ListProperty)ps.propValues.get(f.getName());
                        f.set(o, PropertySheet.parseListField(ps.getConfigurationManager(), ps.getInstanceName(), f.getName(), f.getType(), genericList.get(0), ft, vals));
                        break block20;
                    } else if (FieldType.simpleTypes.contains((Object)ft)) {
                        String val = super.flattenProp(f.getName());
                        try {
                            f.set(o, PropertySheet.parseSimpleField(ps.getConfigurationManager(), ps.getInstanceName(), f.getName(), f.getType(), ft, val));
                        }
                        catch (IllegalArgumentException e) {
                            throw new PropertyException(ps.getInstanceName(), f.getName(), "Incompatible type found, looked up " + f.getName() + " but found an incorrect subclass of Configurable.");
                        }
                    } else {
                        if (!FieldType.mapTypes.contains((Object)ft)) {
                            f.setAccessible(accessible);
                            throw new PropertyException(ps.getInstanceName(), f.getName(), "Unknown field type " + ft.toString());
                        }
                        genericList = PropertySheet.getGenericClass(f);
                        if (genericList.size() != 2) {
                            f.setAccessible(accessible);
                            throw new PropertyException(ps.getInstanceName(), f.getName(), "Failed to extract generic type arguments from field. Found: " + genericList.toString());
                        }
                        MapProperty mapVals = (MapProperty)ps.propValues.get(f.getName());
                        f.set(o, PropertySheet.parseMapField(ps.getConfigurationManager(), ps.getInstanceName(), f.getName(), genericList.get(1), mapVals));
                    }
                    break block20;
                }
                if (nameAnnotation != null) {
                    if (!String.class.isAssignableFrom(f.getType())) {
                        f.setAccessible(accessible);
                        throw new PropertyException(ps.getInstanceName(), f.getName(), "Assigning ConfigurableName to non-String type " + f.getType().getName());
                    }
                    f.set(o, ps.getInstanceName());
                } else if (cmAnnotation != null) {
                    if (!ConfigurationManager.class.isAssignableFrom(f.getType())) {
                        f.setAccessible(accessible);
                        throw new PropertyException(ps.getInstanceName(), f.getName(), "Assigning ConfigManager to non-ConfigurationManager type " + f.getType().getName());
                    }
                    f.set(o, ps.getConfigurationManager());
                }
            }
            f.setAccessible(accessible);
        }
    }

    static Map<String, Object> parseMapField(ConfigurationManager cm, String instanceName, String fieldName, Class<?> genericType, MapProperty input) {
        FieldType genericft = FieldType.getFieldType(genericType);
        if (genericft != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Map.Entry<String, SimpleProperty> e : input.getMap().entrySet()) {
                String newVal = cm.getImmutableGlobalProperties().replaceGlobalProperties(instanceName, fieldName, e.getValue().getValue());
                map.put(e.getKey(), PropertySheet.parseSimpleField(cm, instanceName, fieldName, genericType, genericft, newVal));
            }
            return map;
        }
        throw new PropertyException(instanceName, fieldName, "Map value type parameter is not a valid OLCUT field type, found " + genericType.getName());
    }

    /*
     * WARNING - void declaration
     */
    static Object parseArrayField(ConfigurationManager cm, String instanceName, String fieldName, Class<?> fieldClass, FieldType ft, ListProperty input) {
        ArrayList<String> replaced = new ArrayList<String>();
        ArrayList<Class> removeList = new ArrayList<Class>();
        ArrayList<Class<Class>> classVals = new ArrayList<Class<Class>>(input.getClassList());
        for (SimpleProperty val : input.getSimpleList()) {
            replaced.add(cm.getImmutableGlobalProperties().replaceGlobalProperties(instanceName, fieldName, val.getValue()));
        }
        Object[] output = null;
        switch (ft) {
            case STRING_ARRAY: {
                output = replaced.toArray(new String[0]);
                break;
            }
            case CONFIGURABLE_ARRAY: {
                void var13_17;
                ArrayList<Configurable> configurableList = new ArrayList<Configurable>();
                Class<?> configArrayType = fieldClass.getComponentType();
                for (String string : replaced) {
                    Configurable c = cm.lookup(string);
                    if (c == null) {
                        throw new PropertyException(instanceName, fieldName, fieldName + " looked up an unknown configurable called " + string);
                    }
                    configurableList.add(c);
                }
                for (Class clazz : classVals) {
                    if (configArrayType.isAssignableFrom(clazz)) {
                        configurableList.addAll(cm.lookupAll(clazz, null));
                        removeList.add(clazz);
                        continue;
                    }
                    throw new PropertyException(instanceName, fieldName, "Unassignable class " + clazz.getName() + " to configArrayType " + configArrayType.getName());
                }
                Configurable[] cos = (Configurable[])Array.newInstance(configArrayType, configurableList.size());
                boolean bl = false;
                while (var13_17 < configurableList.size()) {
                    cos[var13_17] = (Configurable)configurableList.get((int)var13_17);
                    ++var13_17;
                }
                output = cos;
                break;
            }
            case BYTE_ARRAY: {
                try {
                    byte[] byArray = new byte[replaced.size()];
                    int i = 0;
                    for (String v : replaced) {
                        byArray[i++] = Byte.parseByte(v);
                    }
                    output = byArray;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new PropertyException(numberFormatException, instanceName, fieldName, String.format("%s is not a byte", ((Object)replaced).toString()));
                }
            }
            case CHAR_ARRAY: {
                char[] cArray = new char[replaced.size()];
                int index = 0;
                for (String v : replaced) {
                    if (v.length() != 1) {
                        throw new PropertyException(instanceName, fieldName, String.format("%s is not a single character", v));
                    }
                    cArray[index++] = v.charAt(0);
                }
                output = cArray;
                break;
            }
            case SHORT_ARRAY: {
                try {
                    short[] ia = new short[replaced.size()];
                    int i = 0;
                    for (String v : replaced) {
                        ia[i++] = Short.parseShort(v);
                    }
                    output = ia;
                    break;
                }
                catch (NumberFormatException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("%s is not a short", ((Object)replaced).toString()));
                }
            }
            case INTEGER_ARRAY: {
                try {
                    int[] ia = new int[replaced.size()];
                    int i = 0;
                    for (String v : replaced) {
                        ia[i++] = Integer.parseInt(v);
                    }
                    output = ia;
                    break;
                }
                catch (NumberFormatException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("%s is not an integer", ((Object)replaced).toString()));
                }
            }
            case LONG_ARRAY: {
                try {
                    long[] la = new long[replaced.size()];
                    int i = 0;
                    for (String v : replaced) {
                        la[i++] = Long.parseLong(v);
                    }
                    output = la;
                    break;
                }
                catch (NumberFormatException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("%s is not an array of long", ((Object)replaced).toString()));
                }
            }
            case FLOAT_ARRAY: {
                try {
                    float[] fa = new float[replaced.size()];
                    int i = 0;
                    for (String v : replaced) {
                        fa[i++] = Float.parseFloat(v);
                    }
                    output = fa;
                    break;
                }
                catch (NumberFormatException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("%s does not specify an array of float", ((Object)replaced).toString()));
                }
            }
            case DOUBLE_ARRAY: {
                try {
                    double[] da = new double[replaced.size()];
                    int i = 0;
                    for (String v : replaced) {
                        da[i++] = Double.parseDouble(v);
                    }
                    output = da;
                    break;
                }
                catch (NumberFormatException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("%s does not specify an array of double", ((Object)replaced).toString()));
                }
            }
            case BOOLEAN_ARRAY: {
                boolean[] ba = new boolean[replaced.size()];
                int i = 0;
                for (String v : replaced) {
                    ba[i++] = Boolean.parseBoolean(v);
                }
                output = ba;
            }
        }
        classVals.removeAll(removeList);
        if (classVals.size() > 0) {
            throw new PropertyException(instanceName, fieldName, "Found class values in a primitive array");
        }
        return output;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    static Object parseListField(ConfigurationManager cm, String instanceName, String fieldName, Class<?> fieldClass, Class<?> genericClass, FieldType ft, ListProperty input) {
        replaced = new ArrayList<String>();
        removeList = new ArrayList<Class>();
        classVals = new ArrayList<Class<Class>>(input.getClassList());
        for (SimpleProperty val : input.getSimpleList()) {
            replaced.add(cm.getImmutableGlobalProperties().replaceGlobalProperties(instanceName, fieldName, val.getValue()));
        }
        output /* !! */  = null;
        switch (1.$SwitchMap$com$oracle$labs$mlrg$olcut$config$FieldType[ft.ordinal()]) {
            case 11: {
                try {
                    if (genericClass.isEnum()) {
                        enumType = genericClass;
                        s = EnumSet.noneOf(enumType);
                        for (String v : replaced) {
                            s.add(Enum.valueOf(enumType, v.toUpperCase()));
                        }
                        ** break;
                    }
                    throw new PropertyException(instanceName, fieldName, String.format("The supplied type parameter %s is not an Enum type", new Object[]{genericClass.getName()}));
lbl21:
                    // 1 sources

                    output /* !! */  = s;
                    break;
                }
                catch (ClassCastException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("The supplied type %s is not an Enum type", new Object[]{genericClass.getName()}));
                }
                catch (IllegalArgumentException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("%s has values not in %s", new Object[]{replaced.toString(), fieldClass}));
                }
            }
            case 12: {
                genericft = FieldType.getFieldType(genericClass);
                if (genericft != null) {
                    list = new ArrayList<Object>(replaced.size());
                    for (String v : replaced) {
                        list.add(PropertySheet.parseSimpleField(cm, instanceName, fieldName, genericClass, genericft, v));
                    }
                    for (Class c : classVals) {
                        if (genericClass.isAssignableFrom(c)) {
                            list.addAll(cm.lookupAll(c, null));
                            removeList.add(c);
                            continue;
                        }
                        throw new PropertyException(instanceName, fieldName, "Unassignable class " + c.getName() + " to genericType " + genericClass.getName());
                    }
                    output /* !! */  = list;
                    break;
                }
                throw new PropertyException(instanceName, fieldName, "List type parameter is not a valid OLCUT field type, found " + genericClass.getName());
            }
            case 13: {
                genericft = FieldType.getFieldType(genericClass);
                if (genericft != null) {
                    set = new HashSet<Object>(replaced.size());
                    for (String v : replaced) {
                        set.add(PropertySheet.parseSimpleField(cm, instanceName, fieldName, genericClass, genericft, v));
                    }
                    for (Class c : classVals) {
                        if (genericClass.isAssignableFrom(c)) {
                            set.addAll(cm.lookupAll(c, null));
                            removeList.add(c);
                            continue;
                        }
                        throw new PropertyException(instanceName, fieldName, "Unassignable class " + c.getName() + " to genericClass " + genericClass.getName());
                    }
                    output /* !! */  = set;
                    break;
                }
                throw new PropertyException(instanceName, fieldName, "List type parameter is not a valid OLCUT field type, found " + genericClass.getName());
            }
        }
        classVals.removeAll(removeList);
        if (classVals.size() > 0) {
            throw new PropertyException(instanceName, fieldName, "Found class values in a primitive array");
        }
        return output /* !! */ ;
    }

    static Object parseSimpleField(ConfigurationManager cm, String instanceName, String fieldName, Class<?> fieldClass, FieldType ft, String val) {
        switch (ft) {
            case STRING: {
                return val;
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(val);
            }
            case BYTE: {
                try {
                    return Byte.parseByte(val);
                }
                catch (NumberFormatException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("%s is not a byte", val));
                }
            }
            case CHAR: {
                if (val.length() != 1) {
                    throw new PropertyException(instanceName, fieldName, String.format("%s is not a single character", val));
                }
                return Character.valueOf(val.charAt(0));
            }
            case SHORT: {
                try {
                    return Short.parseShort(val);
                }
                catch (NumberFormatException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("%s is not a short", val));
                }
            }
            case INTEGER: {
                try {
                    return Integer.parseInt(val);
                }
                catch (NumberFormatException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("%s is not an integer", val));
                }
            }
            case ATOMIC_INTEGER: {
                try {
                    return new AtomicInteger(Integer.parseInt(val));
                }
                catch (NumberFormatException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("%s is not an integer", val));
                }
            }
            case LONG: {
                try {
                    return Long.parseLong(val);
                }
                catch (NumberFormatException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("%s is not a long", val));
                }
            }
            case ATOMIC_LONG: {
                try {
                    return new AtomicLong(Long.parseLong(val));
                }
                catch (NumberFormatException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("%s is not a long", val));
                }
            }
            case FLOAT: {
                try {
                    return Float.valueOf(Float.parseFloat(val));
                }
                catch (NumberFormatException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("%s is not an float", val));
                }
            }
            case DOUBLE: {
                try {
                    return Double.parseDouble(val);
                }
                catch (NumberFormatException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("%s is not a double", val));
                }
            }
            case FILE: {
                return new File(val);
            }
            case PATH: {
                return Paths.get(val, new String[0]);
            }
            case DATE: {
                try {
                    return LocalDate.parse(val);
                }
                catch (DateTimeParseException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("%s could not be parsed by LocalDate.parse()", val));
                }
            }
            case DATE_TIME: {
                try {
                    return OffsetDateTime.parse(val);
                }
                catch (DateTimeParseException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("%s could not be parsed by OffsetDateTime.parse()", val));
                }
            }
            case TIME: {
                try {
                    return OffsetTime.parse(val);
                }
                catch (DateTimeParseException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("%s could not be parsed by OffsetTime.parse()", val));
                }
            }
            case URL: {
                try {
                    return new URL(val);
                }
                catch (MalformedURLException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("%s is not a valid URL", val));
                }
            }
            case RANDOM: {
                logger.warning("@Config on Random fields is deprecated for removal in a future version.");
                try {
                    return new Random(Integer.parseInt(val));
                }
                catch (NumberFormatException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("The seed %s is not an integer", val));
                }
            }
            case ENUM: {
                try {
                    return Enum.valueOf(fieldClass, val);
                }
                catch (IllegalArgumentException ex) {
                    throw new PropertyException(ex, instanceName, fieldName, String.format("%s is not a value of %s", val, fieldClass));
                }
            }
            case CONFIGURABLE: {
                Configurable comp = cm.lookup(val);
                if (comp == null) {
                    throw new PropertyException(instanceName, fieldName, fieldName + " looked up an unknown component called " + val);
                }
                return comp;
            }
        }
        throw new PropertyException(instanceName, fieldName, fieldName + " was not a simple configurable field");
    }

    public static List<Class<?>> getGenericClass(Field f) {
        ArrayList list = new ArrayList();
        Type genericType = f.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            for (Type t : pt.getActualTypeArguments()) {
                if (t instanceof ParameterizedType) {
                    t = ((ParameterizedType)t).getRawType();
                }
                if (!(t instanceof Class)) continue;
                list.add((Class)t);
            }
        }
        return list;
    }

    public synchronized void clearOwner() {
        this.owner = null;
    }

    public Class<T> getConfigurableClass() {
        return this.ownerClass;
    }

    public void setProp(String key, Property val) {
        if (!this.registeredProperties.keySet().contains(key)) {
            throw new PropertyException(this.instanceName, "", "'" + key + "' is not a registered property");
        }
        this.propValues.put(key, val);
    }

    public Property getProperty(String name) {
        return this.propValues.get(name);
    }

    public ConfigurationManager getConfigurationManager() {
        return this.cm;
    }

    public int size() {
        return this.propValues.size();
    }

    public Set<String> getRegisteredProperties() {
        return Collections.unmodifiableSet(this.registeredProperties.keySet());
    }

    public synchronized void setCM(ConfigurationManager cm) {
        this.cm = cm;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PropertySheet)) {
            return false;
        }
        PropertySheet ps = (PropertySheet)obj;
        return this.propValues.equals(ps.propValues);
    }

    public int hashCode() {
        return Objects.hash(this.propValues);
    }

    public PropertySheet<T> copy() {
        return new PropertySheet<T>(this);
    }

    public static Set<Field> getAllFields(Class<? extends Configurable> configurable) {
        return AccessController.doPrivileged(() -> {
            HashSet<Field> ret = new HashSet<Field>();
            ArrayDeque cq = new ArrayDeque();
            cq.add(configurable);
            while (!cq.isEmpty()) {
                Class curr = (Class)cq.remove();
                ret.addAll(Arrays.asList(curr.getDeclaredFields()));
                ret.addAll(Arrays.asList(curr.getFields()));
                Class sc = curr.getSuperclass();
                if (sc != null) {
                    cq.add(sc);
                }
                cq.addAll(Arrays.asList(curr.getInterfaces()));
            }
            ret.removeIf(f -> Modifier.isStatic(f.getModifiers()));
            return ret;
        });
    }

    private static <T extends Configurable> void processAnnotations(PropertySheet<T> propertySheet, Class<T> configurable) throws PropertyException {
        Set<Field> classFields = PropertySheet.getAllFields(configurable);
        for (Field field : classFields) {
            Config configAnnotation = field.getAnnotation(Config.class);
            ConfigurableName nameAnnotation = field.getAnnotation(ConfigurableName.class);
            ConfigManager cmAnnotation = field.getAnnotation(ConfigManager.class);
            if (configAnnotation != null && nameAnnotation != null || nameAnnotation != null && cmAnnotation != null || configAnnotation != null && cmAnnotation != null) {
                throw new PropertyException(propertySheet.getInstanceName(), field.getName(), "Multiple olcut annotations applied to the same field");
            }
            if (configAnnotation != null) {
                super.registerProperty(field.getName(), configAnnotation);
                if (!configAnnotation.redact()) continue;
                propertySheet.redacted.add(field.getName());
                continue;
            }
            if (nameAnnotation != null) {
                if (field.getType().equals(String.class)) continue;
                throw new PropertyException(propertySheet.getInstanceName(), field.getName(), "The component name must be an instance of java.lang.String");
            }
            if (cmAnnotation == null || field.getType().equals(ConfigurationManager.class)) continue;
            throw new PropertyException(propertySheet.getInstanceName(), field.getName(), "The ConfigManager field must be an instance of ConfigurationManager");
        }
    }

    private /* synthetic */ Configurable lambda$getOwner$0(String actualLocation) {
        InputStream serStream = IOUtil.getInputStreamForLocation(actualLocation);
        if (serStream != null) {
            Configurable configurable;
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(serStream, 0x100000));
            try {
                Object deser = ois.readObject();
                configurable = (Configurable)this.ownerClass.cast(deser);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ois.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new PropertyException(ex, this.instanceName, null, "Error reading serialized form from " + actualLocation);
                }
                catch (ClassNotFoundException ex) {
                    throw new PropertyException(ex, this.instanceName, null, "Serialized class not found at " + actualLocation);
                }
            }
            ois.close();
            return configurable;
        }
        return null;
    }

    public static enum StoredFieldType {
        LIST,
        MAP,
        STRING,
        NONE;

    }
}

