/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.IntStream;

public final class SortUtil {
    private SortUtil() {
    }

    public static int[] where(int[] input, IntPredicate func) {
        Integer[] ixs = new Integer[input.length];
        IntStream.range(0, input.length).forEach(i -> {
            ixs[i] = i;
        });
        return Arrays.stream(ixs).filter(i -> func.test(input[i])).mapToInt(i -> i).toArray();
    }

    public static int[] where(double[] input, DoublePredicate func) {
        Integer[] ixs = new Integer[input.length];
        IntStream.range(0, input.length).forEach(i -> {
            ixs[i] = i;
        });
        return Arrays.stream(ixs).filter(i -> func.test(input[i])).mapToInt(i -> i).toArray();
    }

    public static <T> int[] where(List<T> input, Predicate<T> func) {
        Integer[] ixs = new Integer[input.size()];
        IntStream.range(0, input.size()).forEach(i -> {
            ixs[i] = i;
        });
        return Arrays.stream(ixs).filter(i -> func.test(input.get((int)i))).mapToInt(i -> i).toArray();
    }

    public static <T> int[] where(T[] input, Predicate<T> func) {
        Integer[] ixs = new Integer[input.length];
        IntStream.range(0, input.length).forEach(i -> {
            ixs[i] = i;
        });
        return Arrays.stream(ixs).filter(i -> func.test(input[i])).mapToInt(i -> i).toArray();
    }

    public static int[] argsort(int[] input, boolean ascending) {
        return SortUtil.argsort(input, 0, input.length, ascending);
    }

    public static int[] argsort(int[] input, int start, int end, boolean ascending) {
        Object[] array = new SortIntegerTuple[end - start];
        for (int i = start; i < end; ++i) {
            array[i - start] = new SortIntegerTuple(ascending, input[i], i);
        }
        Arrays.sort(array);
        int[] output = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            output[i] = ((SortIntegerTuple)array[i]).index;
        }
        return output;
    }

    public static int[] argsort(double[] input, boolean ascending) {
        return SortUtil.argsort(input, 0, input.length, ascending);
    }

    public static int[] argsort(double[] input, int start, int end, boolean ascending) {
        Object[] array = new SortDoubleTuple[end - start];
        for (int i = start; i < end; ++i) {
            array[i - start] = new SortDoubleTuple(ascending, input[i], i);
        }
        Arrays.sort(array);
        int[] output = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            output[i] = ((SortDoubleTuple)array[i]).index;
        }
        return output;
    }

    public static <T extends Comparable<T>> int[] argsort(List<T> input, boolean ascending) {
        return SortUtil.argsort(input, 0, input.size(), ascending);
    }

    public static <T extends Comparable<T>> int[] argsort(List<T> input, int start, int end, boolean ascending) {
        ArrayList<SortTuple<Comparable>> list = new ArrayList<SortTuple<Comparable>>();
        for (int i = start; i < end; ++i) {
            list.add(new SortTuple<Comparable>(ascending, (Comparable)input.get(i), i));
        }
        Collections.sort(list);
        int[] output = new int[list.size()];
        int i = 0;
        for (SortTuple sortTuple : list) {
            output[i] = sortTuple.index;
            ++i;
        }
        return output;
    }

    public static <T extends Comparable<T>> int[] argsort(T[] input, boolean ascending) {
        return SortUtil.argsort(input, (int)0, (int)input.length, (boolean)ascending);
    }

    public static <T extends Comparable<T>> int[] argsort(T[] input, int start, int end, boolean ascending) {
        ArrayList<SortTuple<T>> list = new ArrayList<SortTuple<T>>();
        for (int i = start; i < end; ++i) {
            list.add(new SortTuple<T>(ascending, input[i], i));
        }
        Collections.sort(list);
        int[] output = new int[list.size()];
        int i = 0;
        for (SortTuple sortTuple : list) {
            output[i] = sortTuple.index;
            ++i;
        }
        return output;
    }

    private static class SortIntegerTuple
    implements Comparable<SortIntegerTuple> {
        private final boolean ascending;
        public final int value;
        public final int index;

        public SortIntegerTuple(boolean ascending, int value, int index) {
            this.ascending = ascending;
            this.value = value;
            this.index = index;
        }

        @Override
        public int compareTo(SortIntegerTuple o) {
            if (this.ascending) {
                return Integer.compare(this.value, o.value);
            }
            return Integer.compare(o.value, this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SortIntegerTuple that = (SortIntegerTuple)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    private static class SortDoubleTuple
    implements Comparable<SortDoubleTuple> {
        private final boolean ascending;
        public final double value;
        public final int index;

        public SortDoubleTuple(boolean ascending, double value, int index) {
            this.ascending = ascending;
            this.value = value;
            this.index = index;
        }

        @Override
        public int compareTo(SortDoubleTuple o) {
            if (this.ascending) {
                return Double.compare(this.value, o.value);
            }
            return Double.compare(o.value, this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SortDoubleTuple that = (SortDoubleTuple)o;
            return Double.compare(that.value, this.value) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    private static class SortTuple<T extends Comparable<T>>
    implements Comparable<SortTuple<T>> {
        private final boolean ascending;
        public final T value;
        public final int index;

        public SortTuple(boolean ascending, T value, int index) {
            this.ascending = ascending;
            this.value = value;
            this.index = index;
        }

        @Override
        public int compareTo(SortTuple<T> o) {
            if (this.ascending) {
                return this.value.compareTo(o.value);
            }
            return o.value.compareTo(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SortTuple sortTuple = (SortTuple)o;
            return this.value.equals(sortTuple.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

